/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.impl.common.CollectionHelper;

public class ElasticsearchSearchQueryElementCollector
implements ElasticsearchSearchPredicateCollector,
ElasticsearchSearchSortCollector {
    private final ElasticsearchSearchPredicateContext rootPredicateContext;
    private JsonObject jsonPredicate;
    private JsonArray jsonSort;
    private Map<SearchProjectionExtractContext.DistanceSortKey, Integer> distanceSorts;

    public ElasticsearchSearchQueryElementCollector(SessionContextImplementor sessionContext) {
        this.rootPredicateContext = new ElasticsearchSearchPredicateContext(sessionContext);
    }

    @Override
    public ElasticsearchSearchPredicateContext getRootPredicateContext() {
        return this.rootPredicateContext;
    }

    @Override
    public void collectPredicate(JsonObject jsonQuery) {
        this.jsonPredicate = jsonQuery;
    }

    @Override
    public void collectSort(JsonElement sort) {
        if (this.jsonSort == null) {
            this.jsonSort = new JsonArray();
        }
        this.jsonSort.add(sort);
    }

    @Override
    public void collectDistanceSort(JsonElement sort, String absoluteFieldPath, GeoPoint center) {
        this.collectSort(sort);
        int index = this.jsonSort.size() - 1;
        if (this.distanceSorts == null) {
            this.distanceSorts = CollectionHelper.newHashMap((int)3);
        }
        this.distanceSorts.put(new SearchProjectionExtractContext.DistanceSortKey(absoluteFieldPath, center), index);
    }

    @Override
    public void collectSort(JsonArray sorts) {
        if (this.jsonSort == null) {
            this.jsonSort = new JsonArray();
        }
        this.jsonSort.addAll(sorts);
    }

    public JsonObject toJsonPredicate() {
        return this.jsonPredicate;
    }

    public JsonArray toJsonSort() {
        return this.jsonSort;
    }

    public SearchProjectionExtractContext toSearchProjectionExecutionContext() {
        return new SearchProjectionExtractContext(this.distanceSorts);
    }
}

