/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class ElasticsearchMatchIdPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements MatchIdPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor IDS = JsonAccessor.root().property("ids").asObject();
    private static final JsonAccessor<JsonElement> VALUES = JsonAccessor.root().property("values");
    private final ElasticsearchSearchContext searchContext;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private List<String> values = new ArrayList<String>();

    public ElasticsearchMatchIdPredicateBuilder(ElasticsearchSearchContext searchContext, ToDocumentIdentifierValueConverter<?> idDslConverter) {
        this.searchContext = searchContext;
        this.idDslConverter = idDslConverter;
    }

    public void value(Object value) {
        ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext = this.searchContext.getToDocumentIdentifierValueConvertContext();
        this.values.add(this.idDslConverter.convertUnknown(value, toDocumentIdentifierValueConvertContext));
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        JsonArray array = this.convert(this.values, context.getTenantId());
        VALUES.set(innerObject, (JsonElement)array);
        IDS.set(outerObject, innerObject);
        return outerObject;
    }

    private JsonArray convert(List<String> list, String tenantId) {
        JsonArray jsonArray = new JsonArray(list.size());
        for (String value : list) {
            jsonArray.add(this.searchContext.toElasticsearchId(tenantId, value));
        }
        return jsonArray;
    }
}

