/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchMatchPredicateBuilder<F>
extends AbstractElasticsearchSearchPredicateBuilder
implements MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> QUERY = JsonAccessor.root().property("query");
    private static final JsonObjectAccessor MATCH = JsonAccessor.root().property("match").asObject();
    private final ElasticsearchSearchContext searchContext;
    private final String absoluteFieldPath;
    private final ToDocumentFieldValueConverter<?, ? extends F> dslToIndexConverter;
    private final ElasticsearchFieldCodec<F> codec;
    private JsonElement value;

    public ElasticsearchMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> dslToIndexConverter, ElasticsearchFieldCodec<F> codec) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.dslToIndexConverter = dslToIndexConverter;
        this.codec = codec;
    }

    public void value(Object value) {
        try {
            Object converted = this.dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.value = this.codec.encode(converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        QUERY.set(innerObject, this.value);
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        MATCH.set(outerObject, middleObject);
        return outerObject;
    }
}

