/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchTargetModel;
import org.hibernate.search.backend.elasticsearch.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchBooleanJunctionPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchAllPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchIdPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchNestedPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchUserProvidedJsonPredicateContributor;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanJunctionPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchSearchPredicateBuilderFactoryImpl
implements ElasticsearchSearchPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final PredicateBuilderFactoryRetrievalStrategy PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new PredicateBuilderFactoryRetrievalStrategy();
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchTargetModel searchTargetModel;

    public ElasticsearchSearchPredicateBuilderFactoryImpl(ElasticsearchSearchContext searchContext, ElasticsearchSearchTargetModel searchTargetModel) {
        this.searchContext = searchContext;
        this.searchTargetModel = searchTargetModel;
    }

    public SearchPredicate toSearchPredicate(ElasticsearchSearchPredicateBuilder builder) {
        return new ElasticsearchSearchPredicate(builder);
    }

    public ElasticsearchSearchPredicateBuilder toImplementation(SearchPredicate predicate) {
        if (!(predicate instanceof ElasticsearchSearchPredicate)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherPredicates(predicate);
        }
        return (ElasticsearchSearchPredicate)predicate;
    }

    public void contribute(ElasticsearchSearchPredicateCollector collector, ElasticsearchSearchPredicateBuilder builder) {
        collector.collectPredicate(builder.build(collector.getRootPredicateContext()));
    }

    public MatchAllPredicateBuilder<ElasticsearchSearchPredicateBuilder> matchAll() {
        return new ElasticsearchMatchAllPredicateBuilder();
    }

    public MatchIdPredicateBuilder<ElasticsearchSearchPredicateBuilder> id() {
        return new ElasticsearchMatchIdPredicateBuilder(this.searchContext, this.searchTargetModel.getIdDslConverter());
    }

    public BooleanJunctionPredicateBuilder<ElasticsearchSearchPredicateBuilder> bool() {
        return new ElasticsearchBooleanJunctionPredicateBuilder();
    }

    public MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> match(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createMatchPredicateBuilder(this.searchContext, absoluteFieldPath);
    }

    public RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> range(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createRangePredicateBuilder(this.searchContext, absoluteFieldPath);
    }

    public SpatialWithinCirclePredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinCircle(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinCirclePredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinPolygonPredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinPolygon(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinPolygonPredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinBoundingBoxPredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinBoundingBox(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinBoundingBoxPredicateBuilder(absoluteFieldPath);
    }

    public NestedPredicateBuilder<ElasticsearchSearchPredicateBuilder> nested(String absoluteFieldPath) {
        this.searchTargetModel.checkNestedField(absoluteFieldPath);
        return new ElasticsearchNestedPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public ElasticsearchSearchPredicateBuilder fromJsonString(String jsonString) {
        return new ElasticsearchUserProvidedJsonPredicateContributor((JsonObject)this.searchContext.getUserFacingGson().fromJson(jsonString, JsonObject.class));
    }

    private static class PredicateBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<ElasticsearchFieldPredicateBuilderFactory> {
        private PredicateBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public ElasticsearchFieldPredicateBuilderFactory extractComponent(ElasticsearchIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.getPredicateBuilderFactory();
        }

        @Override
        public boolean areCompatible(ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2) {
            return component1.isDslCompatibleWith(component2);
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForPredicate(absoluteFieldPath, component1, component2, context);
        }
    }
}

