/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

public class ElasticsearchCompositeFunctionProjection<E, P, T>
implements ElasticsearchCompositeProjection<E, T> {
    private final Function<P, T> transformer;
    private final ElasticsearchSearchProjection<E, P> projection;

    public ElasticsearchCompositeFunctionProjection(Function<P, T> transformer, ElasticsearchSearchProjection<E, P> projection) {
        this.transformer = transformer;
        this.projection = projection;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        this.projection.contributeRequest(requestBody, context);
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        return this.projection.extract(projectionHitMapper, responseBody, hit, context);
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, E extractedData, SearchProjectionTransformContext context) {
        return this.transformer.apply(this.projection.transform(loadingResult, extractedData, context));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection=").append(this.projection).append("]");
        return sb.toString();
    }
}

