/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.engine.search.SearchResult;

public class ElasticsearchSearchQuery<T>
implements SearchQuery<T> {
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final Set<URLEncodedString> indexNames;
    private final SessionContextImplementor sessionContext;
    private final Set<String> routingKeys;
    private final JsonObject payload;
    private final ElasticsearchSearchResultExtractor<T> searchResultExtractor;
    private Long firstResultIndex;
    private Long maxResultsCount;

    public ElasticsearchSearchQuery(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchWorkOrchestrator queryOrchestrator, Set<URLEncodedString> indexNames, SessionContextImplementor sessionContext, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchResultExtractor<T> searchResultExtractor) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.indexNames = indexNames;
        this.sessionContext = sessionContext;
        this.routingKeys = routingKeys;
        this.payload = payload;
        this.searchResultExtractor = searchResultExtractor;
    }

    public void setFirstResult(Long firstResultIndex) {
        this.firstResultIndex = firstResultIndex;
    }

    public void setMaxResults(Long maxResultsCount) {
        this.maxResultsCount = maxResultsCount;
    }

    public String getQueryString() {
        return this.payload.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getQueryString() + "]";
    }

    public SearchResult<T> execute() {
        Object work = this.workFactory.search(this.payload, this.searchResultExtractor).indexes(this.indexNames).paging(this.firstResultIndex, this.maxResultsCount).routingKeys(this.routingKeys).build();
        return ((ElasticsearchLoadableSearchResult)this.queryOrchestrator.submit(work).join()).loadBlocking(this.sessionContext);
    }

    public long executeCount() {
        JsonObject filteredPayload = new JsonObject();
        Optional querySubTree = JsonAccessor.root().property("query").asObject().get(this.payload);
        if (querySubTree.isPresent()) {
            filteredPayload.add("query", (JsonElement)querySubTree.get());
        }
        Object work = this.workFactory.count(this.indexNames).query(filteredPayload).routingKeys(this.routingKeys).build();
        return (Long)this.queryOrchestrator.submit(work).join();
    }
}

