/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.time.Instant;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchInstantFieldCodec
implements ElasticsearchFieldCodec<Instant> {
    public static final ElasticsearchInstantFieldCodec INSTANCE = new ElasticsearchInstantFieldCodec();

    private ElasticsearchInstantFieldCodec() {
    }

    @Override
    public JsonElement encode(Instant value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)value.toEpochMilli());
    }

    @Override
    public Instant decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        Long time = JsonElementTypes.LONG.fromElement(element);
        return Instant.ofEpochMilli(time);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return INSTANCE == other;
    }
}

