/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughFromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeConverterContext;
import org.hibernate.search.util.impl.common.Contracts;

abstract class AbstractElasticsearchIndexFieldTypeConverterContext<S extends AbstractElasticsearchIndexFieldTypeConverterContext<? extends S, F>, F>
implements IndexFieldTypeConverterContext<S, F> {
    private final ElasticsearchIndexFieldTypeBuildContext buildContext;
    private final Class<F> fieldType;
    private ToDocumentFieldValueConverter<?, ? extends F> dslToIndexConverter;
    private FromDocumentFieldValueConverter<? super F, ?> indexToProjectionConverter;

    AbstractElasticsearchIndexFieldTypeConverterContext(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType) {
        this.buildContext = buildContext;
        this.fieldType = fieldType;
    }

    public S dslConverter(ToDocumentFieldValueConverter<?, ? extends F> toIndexConverter) {
        Contracts.assertNotNull(toIndexConverter, (String)"toIndexConverter");
        this.dslToIndexConverter = toIndexConverter;
        return this.thisAsS();
    }

    public S projectionConverter(FromDocumentFieldValueConverter<? super F, ?> fromIndexConverter) {
        Contracts.assertNotNull(fromIndexConverter, (String)"fromIndexConverter");
        this.indexToProjectionConverter = fromIndexConverter;
        return this.thisAsS();
    }

    protected abstract S thisAsS();

    final ElasticsearchIndexFieldTypeBuildContext getBuildContext() {
        return this.buildContext;
    }

    final ToDocumentFieldValueConverter<?, ? extends F> createDslToIndexConverter() {
        return this.dslToIndexConverter == null ? new PassThroughToDocumentFieldValueConverter(this.fieldType) : this.dslToIndexConverter;
    }

    final FromDocumentFieldValueConverter<? super F, ?> createIndexToProjectionConverter() {
        return this.indexToProjectionConverter == null ? new PassThroughFromDocumentFieldValueConverter(this.fieldType) : this.indexToProjectionConverter;
    }
}

