/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchIndexFieldTypeFactoryContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchJsonStringIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchBooleanIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchGeoPointIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchInstantIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIntegerIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchJsonStringIndexFieldTypeContextImpl;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalDateIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLongIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchStringIndexFieldTypeContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchIndexFieldTypeFactoryContextImpl
implements ElasticsearchIndexFieldTypeFactoryContext,
ElasticsearchIndexFieldTypeBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final Gson userFacingGson;

    public ElasticsearchIndexFieldTypeFactoryContextImpl(EventContext eventContext, Gson userFacingGson) {
        this.eventContext = eventContext;
        this.userFacingGson = userFacingGson;
    }

    public <F> StandardIndexFieldTypeContext<?, F> as(Class<F> inputType) {
        if (String.class.equals(inputType)) {
            return this.asString();
        }
        if (Integer.class.equals(inputType)) {
            return this.asInteger();
        }
        if (Long.class.equals(inputType)) {
            return this.asLong();
        }
        if (Boolean.class.equals(inputType)) {
            return this.asBoolean();
        }
        if (LocalDate.class.equals(inputType)) {
            return this.asLocalDate();
        }
        if (Instant.class.equals(inputType)) {
            return this.asInstant();
        }
        if (GeoPoint.class.equals(inputType)) {
            return this.asGeoPoint();
        }
        throw log.cannotGuessFieldType(inputType, this.getEventContext());
    }

    public StringIndexFieldTypeContext<?> asString() {
        return new ElasticsearchStringIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Integer> asInteger() {
        return new ElasticsearchIntegerIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Long> asLong() {
        return new ElasticsearchLongIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Boolean> asBoolean() {
        return new ElasticsearchBooleanIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalDate> asLocalDate() {
        return new ElasticsearchLocalDateIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Instant> asInstant() {
        return new ElasticsearchInstantIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, GeoPoint> asGeoPoint() {
        return new ElasticsearchGeoPointIndexFieldTypeContext(this);
    }

    @Override
    public ElasticsearchJsonStringIndexFieldTypeContext<?> asJsonString(String mappingJsonString) {
        return new ElasticsearchJsonStringIndexFieldTypeContextImpl((ElasticsearchIndexFieldTypeBuildContext)this, mappingJsonString);
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public Gson getUserFacingGson() {
        return this.userFacingGson;
    }
}

