/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.time.Instant;
import java.util.Arrays;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchInstantFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchScalarFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class ElasticsearchInstantIndexFieldTypeContext
extends AbstractElasticsearchScalarFieldTypeContext<ElasticsearchInstantIndexFieldTypeContext, Instant> {
    ElasticsearchInstantIndexFieldTypeContext(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Instant.class, DataType.DATE);
    }

    @Override
    protected ElasticsearchIndexFieldType<Instant> toIndexFieldType(PropertyMapping mapping) {
        mapping.setFormat(Arrays.asList("epoch_millis"));
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        ElasticsearchInstantFieldCodec codec = ElasticsearchInstantFieldCodec.INSTANCE;
        return new ElasticsearchIndexFieldType<Instant>(codec, new ElasticsearchStandardFieldPredicateBuilderFactory<Instant>(dslToIndexConverter, codec), new ElasticsearchStandardFieldSortBuilderFactory<Instant>(this.resolvedSortable, dslToIndexConverter, codec), new ElasticsearchStandardFieldProjectionBuilderFactory<Instant>(this.resolvedProjectable, indexToProjectionConverter, codec), mapping);
    }

    @Override
    protected ElasticsearchInstantIndexFieldTypeContext thisAsS() {
        return this;
    }
}

