/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.impl;

import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.backend.types.IndexFieldType;

public class ElasticsearchIndexFieldType<F>
implements IndexFieldType<F> {
    private final ElasticsearchFieldCodec<F> codec;
    private final ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory;
    private final ElasticsearchFieldSortBuilderFactory sortBuilderFactory;
    private final ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory;
    private final PropertyMapping mapping;

    public ElasticsearchIndexFieldType(ElasticsearchFieldCodec<F> codec, ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory, ElasticsearchFieldSortBuilderFactory sortBuilderFactory, ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory, PropertyMapping mapping) {
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
        this.mapping = mapping;
    }

    public IndexFieldAccessor<F> addField(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode, AbstractTypeMapping parentMapping, String relativeFieldName) {
        ElasticsearchIndexSchemaFieldNode<F> schemaNode = new ElasticsearchIndexSchemaFieldNode<F>(parentNode, this.codec, this.predicateBuilderFactory, this.sortBuilderFactory, this.projectionBuilderFactory);
        String absoluteFieldPath = parentNode.getAbsolutePath(relativeFieldName);
        collector.collect(absoluteFieldPath, schemaNode);
        parentMapping.addProperty(relativeFieldName, this.mapping);
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(relativeFieldName);
        return new ElasticsearchIndexFieldAccessor<F>(jsonAccessor, schemaNode);
    }
}

