/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.impl.common.Futures;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.Throwables;

public abstract class AbstractSimpleElasticsearchWork<R>
implements ElasticsearchWork<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final CompletableFuture<Void> SUCCESSFUL_FUTURE = CompletableFuture.completedFuture(null);
    protected final ElasticsearchRequest request;
    protected final URLEncodedString dirtiedIndexName;
    protected final ElasticsearchRequestSuccessAssessor resultAssessor;
    protected final boolean markIndexDirty;

    protected AbstractSimpleElasticsearchWork(Builder<?> builder) {
        this.request = builder.buildRequest();
        this.dirtiedIndexName = builder.dirtiedIndexName;
        this.resultAssessor = builder.resultAssessor;
        this.markIndexDirty = builder.markIndexDirty;
    }

    @Override
    public Object getInfo() {
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "path = " + this.request.getPath() + ", dirtiedIndexName = " + this.dirtiedIndexName + "]";
    }

    @Override
    public final CompletableFuture<R> execute(ElasticsearchWorkExecutionContext executionContext) {
        return ((CompletableFuture)((CompletableFuture)Futures.create(() -> this.beforeExecute(executionContext, this.request)).thenCompose(ignored -> executionContext.getClient().submit(this.request))).exceptionally(Futures.handler(throwable -> {
            throw log.elasticsearchRequestFailed(this.request, null, Throwables.expectException((Throwable)throwable));
        }))).thenCompose(response -> this.handleResult(executionContext, (ElasticsearchResponse)response));
    }

    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        return SUCCESSFUL_FUTURE;
    }

    protected CompletableFuture<?> afterSuccess(ElasticsearchWorkExecutionContext executionContext) {
        return SUCCESSFUL_FUTURE;
    }

    protected abstract R generateResult(ElasticsearchWorkExecutionContext var1, ElasticsearchResponse var2);

    @Override
    public CompletableFuture<R> aggregate(ElasticsearchWorkAggregator aggregator) {
        return aggregator.addNonBulkable(this);
    }

    private CompletableFuture<R> handleResult(ElasticsearchWorkExecutionContext executionContext, ElasticsearchResponse response) {
        Object result;
        try {
            this.resultAssessor.checkSuccess(response);
            result = this.generateResult(executionContext, response);
            if (this.markIndexDirty) {
                executionContext.registerIndexToRefresh(this.dirtiedIndexName);
            }
        }
        catch (RuntimeException e) {
            throw log.elasticsearchRequestFailed(this.request, response, e);
        }
        return ((CompletableFuture)this.afterSuccess(executionContext).exceptionally(Futures.handler(throwable -> {
            throw log.elasticsearchRequestFailed(this.request, response, Throwables.expectException((Throwable)throwable));
        }))).thenApply(ignored -> result);
    }

    protected static abstract class Builder<B> {
        protected final URLEncodedString dirtiedIndexName;
        protected ElasticsearchRequestSuccessAssessor resultAssessor;
        protected boolean markIndexDirty;

        public Builder(URLEncodedString dirtiedIndexName, ElasticsearchRequestSuccessAssessor resultAssessor) {
            this.dirtiedIndexName = dirtiedIndexName;
            this.resultAssessor = resultAssessor;
        }

        public B markIndexDirty(boolean markIndexDirty) {
            this.markIndexDirty = markIndexDirty;
            return (B)this;
        }

        protected abstract ElasticsearchRequest buildRequest();

        public abstract ElasticsearchWork<?> build();
    }
}

