/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.CreateIndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;

public class CreateIndexWork
extends AbstractSimpleElasticsearchWork<CreateIndexResult> {
    protected CreateIndexWork(Builder builder) {
        super(builder);
    }

    @Override
    protected CreateIndexResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        int statusCode = response.getStatusCode();
        if (ElasticsearchClientUtils.isSuccessCode(statusCode)) {
            return CreateIndexResult.CREATED;
        }
        return CreateIndexResult.ALREADY_EXISTS;
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.Builder<Builder>
    implements CreateIndexWorkBuilder {
        private final GsonProvider gsonProvider;
        private final URLEncodedString indexName;
        private JsonObject payload = new JsonObject();

        public Builder(GsonProvider gsonProvider, URLEncodedString indexName) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.gsonProvider = gsonProvider;
            this.indexName = indexName;
        }

        @Override
        public Builder settings(IndexSettings settings) {
            Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
            this.payload.add("settings", gson.toJsonTree((Object)settings));
            return this;
        }

        @Override
        public Builder mapping(URLEncodedString typeName, RootTypeMapping mapping) {
            Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
            JsonObject mappings = this.payload.getAsJsonObject("mappings");
            if (mappings == null) {
                mappings = new JsonObject();
                this.payload.add("mappings", (JsonElement)mappings);
            }
            mappings.add(typeName.original, gson.toJsonTree((Object)mapping));
            return this;
        }

        @Override
        public Builder ignoreExisting() {
            this.resultAssessor = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorTypes("index_already_exists_exception").build();
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName);
            if (this.payload.size() > 0) {
                builder.body(this.payload);
            }
            return builder.build();
        }

        @Override
        public CreateIndexWork build() {
            return new CreateIndexWork(this);
        }
    }
}

