/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.GetIndexSettingsWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.AssertionFailure;

public class GetIndexSettingsWork
extends AbstractSimpleElasticsearchWork<IndexSettings> {
    private final URLEncodedString indexName;

    protected GetIndexSettingsWork(Builder builder) {
        super(builder);
        this.indexName = builder.indexName;
    }

    @Override
    protected IndexSettings generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.getBody();
        JsonElement index = body.get(this.indexName.original);
        if (index == null || !index.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested index wasn't mentioned in the result: " + body);
        }
        JsonElement settings = index.getAsJsonObject().get("settings");
        if (settings == null || !settings.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested settings weren't mentioned in the result: " + body);
        }
        JsonElement indexSettings = settings.getAsJsonObject().get("index");
        if (indexSettings != null) {
            GsonProvider gsonProvider = context.getGsonProvider();
            return (IndexSettings)gsonProvider.getGson().fromJson(indexSettings, IndexSettings.class);
        }
        return new IndexSettings();
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.Builder<Builder>
    implements GetIndexSettingsWorkBuilder {
        private final URLEncodedString indexName;

        public Builder(URLEncodedString indexName) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(this.indexName).pathComponent(Paths._SETTINGS);
            return builder.build();
        }

        @Override
        public GetIndexSettingsWork build() {
            return new GetIndexSettingsWork(this);
        }
    }
}

