/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.PutIndexMappingWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class PutIndexTypeMappingWork
extends AbstractSimpleElasticsearchWork<Void> {
    protected PutIndexTypeMappingWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.Builder<Builder>
    implements PutIndexMappingWorkBuilder {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final JsonObject payload;

        public Builder(GsonProvider gsonProvider, URLEncodedString indexName, URLEncodedString typeName, RootTypeMapping typeMapping) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.typeName = typeName;
            Gson gson = gsonProvider.getGsonNoSerializeNulls();
            this.payload = gson.toJsonTree((Object)typeMapping).getAsJsonObject();
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName).pathComponent(this.typeName).pathComponent(Paths._MAPPING).body(this.payload);
            return builder.build();
        }

        @Override
        public PutIndexTypeMappingWork build() {
            return new PutIndexTypeMappingWork(this);
        }
    }
}

