/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.SearchWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.impl.common.DefaultLogCategories;
import org.hibernate.search.util.impl.common.LogCategory;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class SearchWork<T>
extends AbstractSimpleElasticsearchWork<ElasticsearchLoadableSearchResult<T>> {
    private static final Log QUERY_LOG = (Log)LoggerFactory.make(Log.class, (LogCategory)DefaultLogCategories.QUERY);
    private final ElasticsearchSearchResultExtractor<T> resultExtractor;

    protected SearchWork(Builder<T> builder) {
        super(builder);
        this.resultExtractor = ((Builder)builder).resultExtractor;
    }

    @Override
    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        QUERY_LOG.executingElasticsearchQuery(request.getPath(), request.getParameters(), executionContext.getGsonProvider().getLogHelper().toString(request.getBodyParts()));
        return super.beforeExecute(executionContext, request);
    }

    @Override
    protected ElasticsearchLoadableSearchResult<T> generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.getBody();
        return this.resultExtractor.extract(body);
    }

    public static class Builder<T>
    extends AbstractSimpleElasticsearchWork.Builder<Builder<T>>
    implements SearchWorkBuilder<T> {
        private final JsonObject payload;
        private final ElasticsearchSearchResultExtractor<T> resultExtractor;
        private final Set<URLEncodedString> indexes = new HashSet<URLEncodedString>();
        private Long from;
        private Long size;
        private Long scrollSize;
        private String scrollTimeout;
        private Set<String> routingKeys;

        public Builder(JsonObject payload, ElasticsearchSearchResultExtractor<T> resultExtractor) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.payload = payload;
            this.resultExtractor = resultExtractor;
        }

        @Override
        public Builder<T> indexes(Collection<URLEncodedString> indexNames) {
            this.indexes.addAll(indexNames);
            return this;
        }

        @Override
        public Builder<T> paging(Long firstResult, Long size) {
            this.from = firstResult;
            this.size = size;
            return this;
        }

        @Override
        public Builder<T> scrolling(long scrollSize, String scrollTimeout) {
            this.scrollSize = scrollSize;
            this.scrollTimeout = scrollTimeout;
            return this;
        }

        @Override
        public SearchWorkBuilder<T> routingKeys(Set<String> routingKeys) {
            this.routingKeys = routingKeys;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().multiValuedPathComponent(this.indexes).pathComponent(Paths._SEARCH).body(this.payload);
            if (this.from != null) {
                builder.param("from", this.from);
            }
            if (this.size != null) {
                builder.param("size", this.size);
            }
            if (this.scrollSize != null && this.scrollTimeout != null) {
                builder.param("size", this.scrollSize);
                builder.param("scroll", this.scrollTimeout);
            }
            if (!this.routingKeys.isEmpty()) {
                builder.multiValuedParam("routing", this.routingKeys);
            }
            return builder.build();
        }

        @Override
        public SearchWork<T> build() {
            return new SearchWork(this);
        }
    }
}

