/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.WaitForIndexStatusWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class WaitForIndexStatusWork
extends AbstractSimpleElasticsearchWork<Void> {
    protected WaitForIndexStatusWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    private static class SuccessAssessor
    implements ElasticsearchRequestSuccessAssessor {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private static final int TIMED_OUT_HTTP_STATUS_CODE = 408;
        private final URLEncodedString indexName;
        private final ElasticsearchIndexStatus requiredIndexStatus;
        private final String timeoutAndUnit;
        private final DefaultElasticsearchRequestSuccessAssessor delegate;

        public SuccessAssessor(URLEncodedString indexName, ElasticsearchIndexStatus requiredIndexStatus, String timeoutAndUnit) {
            this.indexName = indexName;
            this.requiredIndexStatus = requiredIndexStatus;
            this.timeoutAndUnit = timeoutAndUnit;
            this.delegate = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(408).build();
        }

        @Override
        public void checkSuccess(ElasticsearchResponse response) throws SearchException {
            this.delegate.checkSuccess(response);
            if (response.getStatusCode() == 408) {
                String status = response.getBody().get("status").getAsString();
                throw log.unexpectedIndexStatus(this.indexName.original, this.requiredIndexStatus.getElasticsearchString(), status, this.timeoutAndUnit);
            }
        }

        @Override
        public void checkSuccess(JsonObject bulkResponseItem) {
            throw new AssertionFailure("This method should never be called, because WaitForIndexStatusWork is not bulkable.");
        }
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.Builder<Builder>
    implements WaitForIndexStatusWorkBuilder {
        private final URLEncodedString indexName;
        private final ElasticsearchIndexStatus requiredStatus;
        private final String timeout;

        public Builder(URLEncodedString indexName, ElasticsearchIndexStatus requiredStatus, String timeout) {
            super(null, new SuccessAssessor(indexName, requiredStatus, timeout));
            this.indexName = indexName;
            this.requiredStatus = requiredStatus;
            this.timeout = timeout;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(Paths._CLUSTER).pathComponent(Paths.HEALTH).pathComponent(this.indexName).param("wait_for_status", this.requiredStatus.getElasticsearchString()).param("timeout", this.timeout);
            return builder.build();
        }

        @Override
        public WaitForIndexStatusWork build() {
            return new WaitForIndexStatusWork(this);
        }
    }
}

