package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import java.io.Serializable;
import org.hibernate.search.engine.backend.index.spi.IndexSearchScopeBuilder;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.util.common.SearchException;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import java.lang.String;
import org.hibernate.search.engine.search.SearchPredicate;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import com.google.gson.JsonElement;
import java.lang.Throwable;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchDialectName;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.engine.search.SearchSort;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void interruptedWhileWaitingForIndexActivity(final String name, final InterruptedException e) {
        super.log.logf(FQCN, WARN, e, interruptedWhileWaitingForIndexActivity$str(), name);
    }
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }
    private static final String elasticsearchRequestFailed = "HSEARCH400007: Elasticsearch request failed.\nRequest: %1$s\nResponse: %2$s";
    protected String elasticsearchRequestFailed$str() {
        return elasticsearchRequestFailed;
    }
    @Override
    public final SearchException elasticsearchRequestFailed(final ElasticsearchRequest request, final ElasticsearchResponse response, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchBulkedRequestFailed = "HSEARCH400008: Elasticsearch bulked request failed.\nRequest metadata: %1$sResponse: %2$s";
    protected String elasticsearchBulkedRequestFailed$str() {
        return elasticsearchBulkedRequestFailed;
    }
    @Override
    public final SearchException elasticsearchBulkedRequestFailed(final JsonObject requestMetadata, final JsonObject response, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchRequestTimeout = "HSEARCH400010: Elasticsearch connection time-out; check the cluster status, it should be 'green'";
    protected String elasticsearchRequestTimeout$str() {
        return elasticsearchRequestTimeout;
    }
    @Override
    public final SearchException elasticsearchRequestTimeout() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRequestTimeout$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedWhileWaitingForRequestCompletion = "HSEARCH400012: Interrupted while waiting for requests to be processed.";
    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return interruptedWhileWaitingForRequestCompletion;
    }
    @Override
    public final SearchException interruptedWhileWaitingForRequestCompletion(final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), interruptedWhileWaitingForRequestCompletion$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchMappingCreationFailed = "HSEARCH400020: Could not create mapping for index '%1$s': %2$s";
    protected String elasticsearchMappingCreationFailed$str() {
        return elasticsearchMappingCreationFailed;
    }
    @Override
    public final SearchException elasticsearchMappingCreationFailed(final String indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchMappingCreationFailed$str(), indexName, causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIndexStatus = "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    protected String invalidIndexStatus$str() {
        return invalidIndexStatus;
    }
    @Override
    public final SearchException invalidIndexStatus(final String invalidRepresentation, final java.util.List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedIndexStatus = "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$s.";
    protected String unexpectedIndexStatus$str() {
        return unexpectedIndexStatus;
    }
    @Override
    public final SearchException unexpectedIndexStatus(final String indexName, final String expected, final String timeoutAndUnit, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedIndexStatus$str(), indexName, expected, timeoutAndUnit), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchMappingRetrievalForValidationFailed = "HSEARCH400034: Could not retrieve the mappings from Elasticsearch for validation";
    protected String elasticsearchMappingRetrievalForValidationFailed$str() {
        return elasticsearchMappingRetrievalForValidationFailed;
    }
    @Override
    public final SearchException elasticsearchMappingRetrievalForValidationFailed(final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchMappingRetrievalForValidationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String schemaUpdateFailed = "HSEARCH400035: Could not update mappings in index '%1$s': %2$s";
    protected String schemaUpdateFailed$str() {
        return schemaUpdateFailed;
    }
    @Override
    public final SearchException schemaUpdateFailed(final Object indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), schemaUpdateFailed$str(), indexName, causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexMissing = "HSEARCH400050: The index '%1$s' does not exist in the Elasticsearch cluster.";
    protected String indexMissing$str() {
        return indexMissing;
    }
    @Override
    public final SearchException indexMissing(final Object indexName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexMissing$str(), indexName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void executingElasticsearchQuery(final String path, final java.util.Map<String, String> parameters, final String bodyParts) {
        super.log.logf(FQCN, DEBUG, null, executingElasticsearchQuery$str(), path, parameters, bodyParts);
    }
    private static final String executingElasticsearchQuery = "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    protected String executingElasticsearchQuery$str() {
        return executingElasticsearchQuery;
    }
    private static final String tokenizerNamingConflict = "HSEARCH400055: Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.";
    protected String tokenizerNamingConflict$str() {
        return tokenizerNamingConflict;
    }
    @Override
    public final SearchException tokenizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenizerNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String charFilterNamingConflict = "HSEARCH400056: Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.";
    protected String charFilterNamingConflict$str() {
        return charFilterNamingConflict;
    }
    @Override
    public final SearchException charFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), charFilterNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenFilterNamingConflict = "HSEARCH400057: Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.";
    protected String tokenFilterNamingConflict$str() {
        return tokenFilterNamingConflict;
    }
    @Override
    public final SearchException tokenFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenFilterNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchSettingsUpdateFailed = "HSEARCH400067: Could not update settings for index '%1$s'";
    protected String elasticsearchSettingsUpdateFailed$str() {
        return elasticsearchSettingsUpdateFailed;
    }
    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(final Object indexName, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchSettingsUpdateFailed$str(), indexName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchIndexSettingsRetrievalForValidationFailed = "HSEARCH400068: Could not retrieve the index settings from Elasticsearch for validation";
    protected String elasticsearchIndexSettingsRetrievalForValidationFailed$str() {
        return elasticsearchIndexSettingsRetrievalForValidationFailed;
    }
    @Override
    public final SearchException elasticsearchIndexSettingsRetrievalForValidationFailed(final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchIndexSettingsRetrievalForValidationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void closedIndex(final Object indexName) {
        super.log.logf(FQCN, INFO, null, closedIndex$str(), indexName);
    }
    private static final String closedIndex = "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    protected String closedIndex$str() {
        return closedIndex;
    }
    @Override
    public final void openedIndex(final Object indexName) {
        super.log.logf(FQCN, INFO, null, openedIndex$str(), indexName);
    }
    private static final String openedIndex = "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    protected String openedIndex$str() {
        return openedIndex;
    }
    @Override
    public final void usingPasswordOverHttp(final String serverUris) {
        super.log.logf(FQCN, WARN, null, usingPasswordOverHttp$str(), serverUris);
    }
    private static final String usingPasswordOverHttp = "HSEARCH400073: Hibernate Search will connect to Elasticsearch server '%1$s' with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    protected String usingPasswordOverHttp$str() {
        return usingPasswordOverHttp;
    }
    private static final String analyzerNamingConflict = "HSEARCH400074: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    protected String analyzerNamingConflict$str() {
        return analyzerNamingConflict;
    }
    @Override
    public final SearchException analyzerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analyzerNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToApplyAnalysisConfiguration = "HSEARCH400075: Error while applying analysis configuration: %1$s";
    protected String unableToApplyAnalysisConfiguration$str() {
        return unableToApplyAnalysisConfiguration;
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchAnalyzerDefinition = "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return invalidElasticsearchAnalyzerDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchAnalyzerDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchTokenizerDefinition = "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    protected String invalidElasticsearchTokenizerDefinition$str() {
        return invalidElasticsearchTokenizerDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenizerDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchCharFilterDefinition = "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    protected String invalidElasticsearchCharFilterDefinition$str() {
        return invalidElasticsearchCharFilterDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchCharFilterDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchTokenFilterDefinition = "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return invalidElasticsearchTokenFilterDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenFilterDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToDetectElasticsearchVersion = "HSEARCH400080: Failed to detect the Elasticsearch version running on the cluster.";
    protected String failedToDetectElasticsearchVersion$str() {
        return failedToDetectElasticsearchVersion;
    }
    @Override
    public final SearchException failedToDetectElasticsearchVersion(final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToDetectElasticsearchVersion$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedElasticsearchVersion = "HSEARCH400081: An unsupported Elasticsearch version runs on the Elasticsearch cluster: '%s'. Please refer to the documentation to know which versions are supported.";
    protected String unsupportedElasticsearchVersion$str() {
        return unsupportedElasticsearchVersion;
    }
    @Override
    public final SearchException unsupportedElasticsearchVersion(final ElasticsearchVersion version) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedElasticsearchVersion$str(), version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void executedRequest(final String method, final String path, final java.util.Map<String, String> getParameters, final int bodyParts, final long timeInMs, final int responseStatusCode, final String responseStatusMessage) {
        super.log.logf(FQCN, DEBUG, null, executedRequest7$str(), method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage);
    }
    private static final String executedRequest7 = "HSEARCH400082: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'.";
    protected String executedRequest7$str() {
        return executedRequest7;
    }
    @Override
    public final void unknownElasticsearchVersion(final ElasticsearchVersion version) {
        super.log.logf(FQCN, WARN, null, unknownElasticsearchVersion$str(), version);
    }
    private static final String unknownElasticsearchVersion = "HSEARCH400085: Hibernate Search may not work correctly, because an unknown Elasticsearch version runs on the Elasticsearch cluster: '%s'.";
    protected String unknownElasticsearchVersion$str() {
        return unknownElasticsearchVersion;
    }
    private static final String normalizerNamingConflict = "HSEARCH400086: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    protected String normalizerNamingConflict$str() {
        return normalizerNamingConflict;
    }
    @Override
    public final SearchException normalizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), normalizerNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseElasticsearchResponse = "HSEARCH400089: Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.";
    protected String failedToParseElasticsearchResponse$str() {
        return failedToParseElasticsearchResponse;
    }
    @Override
    public final SearchException failedToParseElasticsearchResponse(final int statusCode, final String statusPhrase, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToParseElasticsearchResponse$str(), statusCode, statusPhrase), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchResponseIndicatesFailure = "HSEARCH400090: Elasticsearch response indicates a failure.";
    protected String elasticsearchResponseIndicatesFailure$str() {
        return elasticsearchResponseIndicatesFailure;
    }
    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseIndicatesFailure$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String threadInterruptedWhileSubmittingChangeset = "HSEARCH400091: The thread was interrupted while a changeset was being submitted to '%1$s'. The changeset has been discarded.";
    protected String threadInterruptedWhileSubmittingChangeset$str() {
        return threadInterruptedWhileSubmittingChangeset;
    }
    @Override
    public final SearchException threadInterruptedWhileSubmittingChangeset(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), threadInterruptedWhileSubmittingChangeset$str(), orchestratorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String orchestratorShutDownBeforeSubmittingChangeset = "HSEARCH400092: A changeset was submitted after Hibernate Search shutdown was requested to '%1$s'. The changeset has been discarded.";
    protected String orchestratorShutDownBeforeSubmittingChangeset$str() {
        return orchestratorShutDownBeforeSubmittingChangeset;
    }
    @Override
    public final SearchException orchestratorShutDownBeforeSubmittingChangeset(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), orchestratorShutDownBeforeSubmittingChangeset$str(), orchestratorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void executedRequest(final String method, final String path, final java.util.Map<String, String> getParameters, final int bodyParts, final long timeInMs, final int responseStatusCode, final String responseStatusMessage, final String requestBodyParts, final String responseBody) {
        super.log.logf(FQCN, TRACE, null, executedRequest9$str(), method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody);
    }
    private static final String executedRequest9 = "HSEARCH400093: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    protected String executedRequest9$str() {
        return executedRequest9;
    }
    private static final String cannotMixElasticsearchSearchScopeWithOtherType = "HSEARCH400502: A search query cannot have a scope spanning both an Elasticsearch index and another type of index. Base scope was: '%1$s', Elasticsearch index was: '%2$s'";
    protected String cannotMixElasticsearchSearchScopeWithOtherType$str() {
        return cannotMixElasticsearchSearchScopeWithOtherType;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchScopeWithOtherType(final IndexSearchScopeBuilder baseScope, final ElasticsearchIndexManager elasticsearchIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchScopeWithOtherBackend = "HSEARCH400503: A search query cannot have a scope spanning multiple Elasticsearch backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    protected String cannotMixElasticsearchSearchScopeWithOtherBackend$str() {
        return cannotMixElasticsearchSearchScopeWithOtherBackend;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchScopeWithOtherBackend(final IndexSearchScopeBuilder baseScope, final ElasticsearchIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownFieldForSearch = "HSEARCH400504: Unknown field '%1$s'.";
    protected String unknownFieldForSearch$str() {
        return unknownFieldForSearch;
    }
    @Override
    public final SearchException unknownFieldForSearch(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForSearch$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchExtensionOnUnknownType = "HSEARCH400506: The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.";
    protected String elasticsearchExtensionOnUnknownType$str() {
        return elasticsearchExtensionOnUnknownType;
    }
    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchExtensionOnUnknownType$str(), context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchQueryWithOtherPredicates = "HSEARCH400508: An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search scope. Given predicate was: '%1$s'";
    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return cannotMixElasticsearchSearchQueryWithOtherPredicates;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonObjectFieldForNestedQuery = "HSEARCH400509: Field '%1$s' is not an object field.";
    protected String nonObjectFieldForNestedQuery$str() {
        return nonObjectFieldForNestedQuery;
    }
    @Override
    public final SearchException nonObjectFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonNestedFieldForNestedQuery = "HSEARCH400510: Object field '%1$s' is not stored as nested.";
    protected String nonNestedFieldForNestedQuery$str() {
        return nonNestedFieldForNestedQuery;
    }
    @Override
    public final SearchException nonNestedFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchSortWithOtherSorts = "HSEARCH400511: An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search scope. Given sort was: '%1$s'";
    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return cannotMixElasticsearchSearchSortWithOtherSorts;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiTenancyRequiredButNotSupportedByBackend = "HSEARCH400514: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return multiTenancyRequiredButNotSupportedByBackend;
    }
    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(final String indexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMultiTenancyStrategyName = "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    protected String invalidMultiTenancyStrategyName$str() {
        return invalidMultiTenancyStrategyName;
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final java.util.List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tenantIdProvidedButMultiTenancyDisabled = "HSEARCH400516: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return tenantIdProvidedButMultiTenancyDisabled;
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final String tenantId, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiTenancyEnabledButNoTenantIdProvided = "HSEARCH400517: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return multiTenancyEnabledButNoTenantIdProvided;
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clientUnwrappingWithUnkownType = "HSEARCH400518: Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.";
    protected String clientUnwrappingWithUnkownType$str() {
        return clientUnwrappingWithUnkownType;
    }
    @Override
    public final SearchException clientUnwrappingWithUnkownType(final Class<?> requestedClass, final Class<?> actualClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), clientUnwrappingWithUnkownType$str(), requestedClass, actualClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String backendUnwrappingWithUnknownType = "HSEARCH400519: Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    protected String backendUnwrappingWithUnknownType$str() {
        return backendUnwrappingWithUnknownType;
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexSchemaNodeNameConflict = "HSEARCH400520: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    protected String indexSchemaNodeNameConflict$str() {
        return indexSchemaNodeNameConflict;
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), name), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rangePredicatesNotSupportedByGeoPoint = "HSEARCH400523: Range predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    protected String rangePredicatesNotSupportedByGeoPoint$str() {
        return rangePredicatesNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException rangePredicatesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangePredicatesNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String matchPredicatesNotSupportedByGeoPoint = "HSEARCH400524: Match predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    protected String matchPredicatesNotSupportedByGeoPoint$str() {
        return matchPredicatesNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException matchPredicatesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), matchPredicatesNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldForDocumentElement = "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    protected String invalidFieldForDocumentElement$str() {
        return invalidFieldForDocumentElement;
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchResponseMissingData = "HSEARCH400526: Expected data was missing in the Elasticsearch response.";
    protected String elasticsearchResponseMissingData$str() {
        return elasticsearchResponseMissingData;
    }
    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        final AssertionFailure result = new AssertionFailure(String.format(getLoggingLocale(), elasticsearchResponseMissingData$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String spatialPredicatesNotSupportedByFieldType = "HSEARCH400527: Spatial predicates are not supported by this field's type.";
    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return spatialPredicatesNotSupportedByFieldType;
    }
    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), spatialPredicatesNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String distanceOperationsNotSupportedByFieldType = "HSEARCH400528: Distance related operations are not supported by this field's type.";
    protected String distanceOperationsNotSupportedByFieldType$str() {
        return distanceOperationsNotSupportedByFieldType;
    }
    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), distanceOperationsNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String minimumShouldMatchConflictingConstraints = "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    protected String minimumShouldMatchConflictingConstraints$str() {
        return minimumShouldMatchConflictingConstraints;
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ceiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ceiling));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateNormalizedIndexNames = "HSEARCH400530: Duplicate index names when normalized to conform to Elasticsearch rules: '%1$s' and '%2$s' both become '%3$s'";
    protected String duplicateNormalizedIndexNames$str() {
        return duplicateNormalizedIndexNames;
    }
    @Override
    public final SearchException duplicateNormalizedIndexNames(final String firstHibernateSearchIndexName, final String secondHibernateSearchIndexName, final String elasticsearchIndexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateNormalizedIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, elasticsearchIndexName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchResponseUnknownIndexName = "HSEARCH400531: Unknown index name encountered in Elasticsearch response: '%1$s'";
    protected String elasticsearchResponseUnknownIndexName$str() {
        return elasticsearchResponseUnknownIndexName;
    }
    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(final String elasticsearchIndexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvertDslParameter = "HSEARCH400532: Unable to convert DSL parameter: %1$s";
    protected String cannotConvertDslParameter$str() {
        return cannotConvertDslParameter;
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexManagerUnwrappingWithUnknownType = "HSEARCH400533: Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return indexManagerUnwrappingWithUnknownType;
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchTypedAnalyzerDefinition = "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return invalidElasticsearchTypedAnalyzerDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotApplyAnalyzerAndNormalizer = "HSEARCH400535: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return cannotApplyAnalyzerAndNormalizer;
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseAnalyzerOnSortableField = "HSEARCH400536: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    protected String cannotUseAnalyzerOnSortableField$str() {
        return cannotUseAnalyzerOnSortableField;
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String analysisComponentParameterConflict = "HSEARCH400537: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    protected String analysisComponentParameterConflict$str() {
        return analysisComponentParameterConflict;
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final JsonElement value1, final JsonElement value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchQueryWithOtherProjections = "HSEARCH400538: An Elasticsearch query cannot include search projections built using a non-Elasticsearch search scope. Given projection was: '%1$s'";
    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return cannotMixElasticsearchSearchQueryWithOtherProjections;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(final org.hibernate.search.engine.search.SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProjectionInvalidType = "HSEARCH400539: Invalid type '%2$s' for projection on field '%1$s'.";
    protected String invalidProjectionInvalidType$str() {
        return invalidProjectionInvalidType;
    }
    @Override
    public final SearchException invalidProjectionInvalidType(final String absoluteFieldPath, final Class<?> type, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidProjectionInvalidType$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String traditionalSortNotSupportedByGeoPoint = "HSEARCH400540: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return traditionalSortNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), traditionalSortNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForPredicate = "HSEARCH400541: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForPredicate$str() {
        return conflictingFieldTypesForPredicate;
    }
    @Override
    public final SearchException conflictingFieldTypesForPredicate(final String absoluteFieldPath, final ElasticsearchFieldPredicateBuilderFactory component1, final ElasticsearchFieldPredicateBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForSort = "HSEARCH400542: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForSort$str() {
        return conflictingFieldTypesForSort;
    }
    @Override
    public final SearchException conflictingFieldTypesForSort(final String absoluteFieldPath, final ElasticsearchFieldSortBuilderFactory component1, final ElasticsearchFieldSortBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForProjection = "HSEARCH400543: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForProjection$str() {
        return conflictingFieldTypesForProjection;
    }
    @Override
    public final SearchException conflictingFieldTypesForProjection(final String absoluteFieldPath, final ElasticsearchFieldProjectionBuilderFactory component1, final ElasticsearchFieldProjectionBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShutdownBackend = "HSEARCH400544: Failed to shut down the Elasticsearch backend.";
    protected String failedToShutdownBackend$str() {
        return failedToShutdownBackend;
    }
    @Override
    public final SearchException failedToShutdownBackend(final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToShutdownBackend$str()), cause, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGuessFieldType = "HSEARCH400545: Cannot guess field type for input type %1$s.";
    protected String cannotGuessFieldType$str() {
        return cannotGuessFieldType;
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonProjectableField = "HSEARCH400547: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    protected String nonProjectableField$str() {
        return nonProjectableField;
    }
    @Override
    public final SearchException nonProjectableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonProjectableField$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsortableField = "HSEARCH400548: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    protected String unsortableField$str() {
        return unsortableField;
    }
    @Override
    public final SearchException unsortableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsortableField$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingIdentifierTypesForPredicate = "HSEARCH400549: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    protected String conflictingIdentifierTypesForPredicate$str() {
        return conflictingIdentifierTypesForPredicate;
    }
    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(final org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter<?> component1, final org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter<?> component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShutdownIndexManager = "HSEARCH400550: Failed to shut down the Elasticsearch index manager with name '%1$s'.";
    protected String failedToShutdownIndexManager$str() {
        return failedToShutdownIndexManager;
    }
    @Override
    public final SearchException failedToShutdownIndexManager(final String indexName, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToShutdownIndexManager$str(), indexName), cause, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchSkippedBecauseOfPreviousWork = "HSEARCH400551: The operation was skipped due to the failure of a previous work in the same changeset.";
    protected String elasticsearchSkippedBecauseOfPreviousWork$str() {
        return elasticsearchSkippedBecauseOfPreviousWork;
    }
    @Override
    public final SearchException elasticsearchSkippedBecauseOfPreviousWork(final Throwable skippingCause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchSkippedBecauseOfPreviousWork$str()), skippingCause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIndexLifecycleStrategyName = "HSEARCH400552: Invalid index lifecycle strategy name: '%1$s'. Valid names are: %2$s.";
    protected String invalidIndexLifecycleStrategyName$str() {
        return invalidIndexLifecycleStrategyName;
    }
    @Override
    public final SearchException invalidIndexLifecycleStrategyName(final String invalidRepresentation, final java.util.List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexLifecycleStrategyName$str(), invalidRepresentation, validRepresentations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String textPredicatesNotSupportedByFieldType = "HSEARCH400553: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    protected String textPredicatesNotSupportedByFieldType$str() {
        return textPredicatesNotSupportedByFieldType;
    }
    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), textPredicatesNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteFieldDefinition = "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    protected String incompleteFieldDefinition$str() {
        return incompleteFieldDefinition;
    }
    @Override
    public final SearchException incompleteFieldDefinition(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompleteFieldDefinition$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateReferenceMultipleTimes = "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    protected String cannotCreateReferenceMultipleTimes$str() {
        return cannotCreateReferenceMultipleTimes;
    }
    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateReferenceMultipleTimes$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchVersion = "HSEARCH400556: Invalid Elasticsearch version: '%1$s'. The version must be in the form 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and '-qualifier' is an optional string of word characters (alphanumeric or '_').";
    protected String invalidElasticsearchVersion$str() {
        return invalidElasticsearchVersion;
    }
    @Override
    public final SearchException invalidElasticsearchVersion(final String versionString) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchVersion$str(), versionString));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDialectName = "HSEARCH400558: Invalid Elasticsearch dialect name: '%1$s'. Valid names are: %2$s.";
    protected String invalidDialectName$str() {
        return invalidDialectName;
    }
    @Override
    public final SearchException invalidDialectName(final String normalizedValue, final java.util.List<String> validValues) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDialectName$str(), normalizedValue, validValues));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedElasticsearchVersion = "HSEARCH400559: Unexpected Elasticsearch version: '%1$s'. This version would require dialect '%2$s', but Hibernate Search was configured to use dialect '%3$s'.";
    protected String unexpectedElasticsearchVersion$str() {
        return unexpectedElasticsearchVersion;
    }
    @Override
    public final SearchException unexpectedElasticsearchVersion(final ElasticsearchVersion actualVersion, final ElasticsearchDialectName appropriateDialectName, final ElasticsearchDialectName configuredDialectName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedElasticsearchVersion$str(), actualVersion, appropriateDialectName, configuredDialectName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
