/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.dialect.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchDialectName;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.dialect.impl.Elasticsearch56Dialect;
import org.hibernate.search.backend.elasticsearch.dialect.impl.Elasticsearch6Dialect;
import org.hibernate.search.backend.elasticsearch.dialect.impl.Elasticsearch7Dialect;
import org.hibernate.search.backend.elasticsearch.dialect.impl.ElasticsearchDialect;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDialectFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public ElasticsearchDialect create(ElasticsearchDialectName dialectName) {
        switch (dialectName) {
            case ES_5_6: {
                return new Elasticsearch56Dialect();
            }
            case ES_6: {
                return new Elasticsearch6Dialect();
            }
            case ES_7: {
                return new Elasticsearch7Dialect();
            }
        }
        throw new AssertionFailure("Unexpected dialect name in the create() method: " + (Object)((Object)dialectName));
    }

    public ElasticsearchDialectName getAppropriateDialectName(ElasticsearchVersion version) {
        if (version.getMajor() < 5) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (version.getMajor() == 5) {
            if (version.getMinor() < 6) {
                throw log.unsupportedElasticsearchVersion(version);
            }
            if (version.getMinor() != 6) {
                log.unknownElasticsearchVersion(version);
            }
            return ElasticsearchDialectName.ES_5_6;
        }
        if (version.getMajor() == 6) {
            return ElasticsearchDialectName.ES_6;
        }
        if (version.getMajor() != 7) {
            log.unknownElasticsearchVersion(version);
        }
        return ElasticsearchDialectName.ES_7;
    }

    public void checkAppropriate(ElasticsearchDialectName configuredDialectName, ElasticsearchVersion version) {
        ElasticsearchDialectName appropriateDialectName = this.getAppropriateDialectName(version);
        if (!appropriateDialectName.equals((Object)configuredDialectName)) {
            throw log.unexpectedElasticsearchVersion(version, appropriateDialectName, configuredDialectName);
        }
    }
}

