/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.management.impl;

import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexLifecycleStrategyName;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.util.common.AssertionFailure;

public class ElasticsearchIndexLifecycleStrategy {
    private final ElasticsearchIndexLifecycleStrategyName strategyName;
    protected final ElasticsearchIndexLifecycleExecutionOptions executionOptions;

    public ElasticsearchIndexLifecycleStrategy(ElasticsearchIndexLifecycleStrategyName strategyName, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        this.strategyName = strategyName;
        this.executionOptions = executionOptions;
    }

    public void onStart(ElasticsearchIndexAdministrationClient client, IndexManagerStartContext context) {
        switch (this.strategyName) {
            case CREATE: {
                client.createIfAbsent(this.executionOptions);
                break;
            }
            case DROP_AND_CREATE: 
            case DROP_AND_CREATE_AND_DROP: {
                client.dropAndCreate(this.executionOptions);
                break;
            }
            case UPDATE: {
                client.update(this.executionOptions);
                break;
            }
            case VALIDATE: {
                client.validate(this.executionOptions, context.getFailureCollector());
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected index management strategy: " + (Object)((Object)this.strategyName));
            }
        }
    }

    public void onStop(ElasticsearchIndexAdministrationClient client) {
        switch (this.strategyName) {
            case DROP_AND_CREATE_AND_DROP: {
                client.dropIfExisting(this.executionOptions);
                break;
            }
            case CREATE: 
            case DROP_AND_CREATE: 
            case UPDATE: 
            case VALIDATE: {
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected index management strategy: " + (Object)((Object)this.strategyName));
            }
        }
    }
}

