/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchDialectName;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.index.spi.IndexSearchScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String elasticsearchRequestFailed = "HSEARCH400007: Elasticsearch request failed.\nRequest: %1$s\nResponse: %2$s";
    private static final String elasticsearchBulkedRequestFailed = "HSEARCH400008: Elasticsearch bulked request failed.\nRequest metadata: %1$sResponse: %2$s";
    private static final String elasticsearchRequestTimeout = "HSEARCH400010: Elasticsearch connection time-out; check the cluster status, it should be 'green'";
    private static final String interruptedWhileWaitingForRequestCompletion = "HSEARCH400012: Interrupted while waiting for requests to be processed.";
    private static final String elasticsearchMappingCreationFailed = "HSEARCH400020: Could not create mapping for index '%1$s': %2$s";
    private static final String invalidIndexStatus = "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    private static final String unexpectedIndexStatus = "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$s.";
    private static final String elasticsearchMappingRetrievalForValidationFailed = "HSEARCH400034: Could not retrieve the mappings from Elasticsearch for validation";
    private static final String schemaUpdateFailed = "HSEARCH400035: Could not update mappings in index '%1$s': %2$s";
    private static final String indexMissing = "HSEARCH400050: The index '%1$s' does not exist in the Elasticsearch cluster.";
    private static final String executingElasticsearchQuery = "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    private static final String tokenizerNamingConflict = "HSEARCH400055: Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.";
    private static final String charFilterNamingConflict = "HSEARCH400056: Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.";
    private static final String tokenFilterNamingConflict = "HSEARCH400057: Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.";
    private static final String elasticsearchSettingsUpdateFailed = "HSEARCH400067: Could not update settings for index '%1$s'";
    private static final String elasticsearchIndexSettingsRetrievalForValidationFailed = "HSEARCH400068: Could not retrieve the index settings from Elasticsearch for validation";
    private static final String closedIndex = "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    private static final String openedIndex = "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    private static final String usingPasswordOverHttp = "HSEARCH400073: Hibernate Search will connect to Elasticsearch server '%1$s' with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    private static final String analyzerNamingConflict = "HSEARCH400074: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    private static final String unableToApplyAnalysisConfiguration = "HSEARCH400075: Error while applying analysis configuration: %1$s";
    private static final String invalidElasticsearchAnalyzerDefinition = "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    private static final String invalidElasticsearchTokenizerDefinition = "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    private static final String invalidElasticsearchCharFilterDefinition = "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    private static final String invalidElasticsearchTokenFilterDefinition = "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    private static final String failedToDetectElasticsearchVersion = "HSEARCH400080: Failed to detect the Elasticsearch version running on the cluster.";
    private static final String unsupportedElasticsearchVersion = "HSEARCH400081: An unsupported Elasticsearch version runs on the Elasticsearch cluster: '%s'. Please refer to the documentation to know which versions are supported.";
    private static final String executedRequest7 = "HSEARCH400082: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'.";
    private static final String unknownElasticsearchVersion = "HSEARCH400085: Hibernate Search may not work correctly, because an unknown Elasticsearch version runs on the Elasticsearch cluster: '%s'.";
    private static final String normalizerNamingConflict = "HSEARCH400086: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    private static final String failedToParseElasticsearchResponse = "HSEARCH400089: Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.";
    private static final String elasticsearchResponseIndicatesFailure = "HSEARCH400090: Elasticsearch response indicates a failure.";
    private static final String threadInterruptedWhileSubmittingChangeset = "HSEARCH400091: The thread was interrupted while a changeset was being submitted to '%1$s'. The changeset has been discarded.";
    private static final String orchestratorShutDownBeforeSubmittingChangeset = "HSEARCH400092: A changeset was submitted after Hibernate Search shutdown was requested to '%1$s'. The changeset has been discarded.";
    private static final String executedRequest9 = "HSEARCH400093: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    private static final String cannotMixElasticsearchSearchScopeWithOtherType = "HSEARCH400502: A search query cannot have a scope spanning both an Elasticsearch index and another type of index. Base scope was: '%1$s', Elasticsearch index was: '%2$s'";
    private static final String cannotMixElasticsearchSearchScopeWithOtherBackend = "HSEARCH400503: A search query cannot have a scope spanning multiple Elasticsearch backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    private static final String unknownFieldForSearch = "HSEARCH400504: Unknown field '%1$s'.";
    private static final String elasticsearchExtensionOnUnknownType = "HSEARCH400506: The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.";
    private static final String cannotMixElasticsearchSearchQueryWithOtherPredicates = "HSEARCH400508: An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search scope. Given predicate was: '%1$s'";
    private static final String nonObjectFieldForNestedQuery = "HSEARCH400509: Field '%1$s' is not an object field.";
    private static final String nonNestedFieldForNestedQuery = "HSEARCH400510: Object field '%1$s' is not stored as nested.";
    private static final String cannotMixElasticsearchSearchSortWithOtherSorts = "HSEARCH400511: An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search scope. Given sort was: '%1$s'";
    private static final String multiTenancyRequiredButNotSupportedByBackend = "HSEARCH400514: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    private static final String invalidMultiTenancyStrategyName = "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    private static final String tenantIdProvidedButMultiTenancyDisabled = "HSEARCH400516: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    private static final String multiTenancyEnabledButNoTenantIdProvided = "HSEARCH400517: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    private static final String clientUnwrappingWithUnkownType = "HSEARCH400518: Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.";
    private static final String backendUnwrappingWithUnknownType = "HSEARCH400519: Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    private static final String indexSchemaNodeNameConflict = "HSEARCH400520: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    private static final String rangePredicatesNotSupportedByGeoPoint = "HSEARCH400523: Range predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    private static final String matchPredicatesNotSupportedByGeoPoint = "HSEARCH400524: Match predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    private static final String invalidFieldForDocumentElement = "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    private static final String elasticsearchResponseMissingData = "HSEARCH400526: Expected data was missing in the Elasticsearch response.";
    private static final String spatialPredicatesNotSupportedByFieldType = "HSEARCH400527: Spatial predicates are not supported by this field's type.";
    private static final String distanceOperationsNotSupportedByFieldType = "HSEARCH400528: Distance related operations are not supported by this field's type.";
    private static final String minimumShouldMatchConflictingConstraints = "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    private static final String duplicateNormalizedIndexNames = "HSEARCH400530: Duplicate index names when normalized to conform to Elasticsearch rules: '%1$s' and '%2$s' both become '%3$s'";
    private static final String elasticsearchResponseUnknownIndexName = "HSEARCH400531: Unknown index name encountered in Elasticsearch response: '%1$s'";
    private static final String cannotConvertDslParameter = "HSEARCH400532: Unable to convert DSL parameter: %1$s";
    private static final String indexManagerUnwrappingWithUnknownType = "HSEARCH400533: Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    private static final String invalidElasticsearchTypedAnalyzerDefinition = "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    private static final String cannotApplyAnalyzerAndNormalizer = "HSEARCH400535: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    private static final String cannotUseAnalyzerOnSortableField = "HSEARCH400536: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    private static final String analysisComponentParameterConflict = "HSEARCH400537: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    private static final String cannotMixElasticsearchSearchQueryWithOtherProjections = "HSEARCH400538: An Elasticsearch query cannot include search projections built using a non-Elasticsearch search scope. Given projection was: '%1$s'";
    private static final String invalidProjectionInvalidType = "HSEARCH400539: Invalid type '%2$s' for projection on field '%1$s'.";
    private static final String traditionalSortNotSupportedByGeoPoint = "HSEARCH400540: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    private static final String conflictingFieldTypesForPredicate = "HSEARCH400541: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String conflictingFieldTypesForSort = "HSEARCH400542: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String conflictingFieldTypesForProjection = "HSEARCH400543: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String failedToShutdownBackend = "HSEARCH400544: Failed to shut down the Elasticsearch backend.";
    private static final String cannotGuessFieldType = "HSEARCH400545: Cannot guess field type for input type %1$s.";
    private static final String nonProjectableField = "HSEARCH400547: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    private static final String unsortableField = "HSEARCH400548: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    private static final String conflictingIdentifierTypesForPredicate = "HSEARCH400549: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    private static final String failedToShutdownIndexManager = "HSEARCH400550: Failed to shut down the Elasticsearch index manager with name '%1$s'.";
    private static final String elasticsearchSkippedBecauseOfPreviousWork = "HSEARCH400551: The operation was skipped due to the failure of a previous work in the same changeset.";
    private static final String invalidIndexLifecycleStrategyName = "HSEARCH400552: Invalid index lifecycle strategy name: '%1$s'. Valid names are: %2$s.";
    private static final String textPredicatesNotSupportedByFieldType = "HSEARCH400553: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    private static final String incompleteFieldDefinition = "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    private static final String cannotCreateReferenceMultipleTimes = "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    private static final String invalidElasticsearchVersion = "HSEARCH400556: Invalid Elasticsearch version: '%1$s'. The version must be in the form 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and '-qualifier' is an optional string of word characters (alphanumeric or '_').";
    private static final String invalidDialectName = "HSEARCH400558: Invalid Elasticsearch dialect name: '%1$s'. Valid names are: %2$s.";
    private static final String unexpectedElasticsearchVersion = "HSEARCH400559: Unexpected Elasticsearch version: '%1$s'. This version would require dialect '%2$s', but Hibernate Search was configured to use dialect '%3$s'.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(String name, InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.interruptedWhileWaitingForIndexActivity$str(), (Object)name);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    protected String elasticsearchRequestFailed$str() {
        return elasticsearchRequestFailed;
    }

    @Override
    public final SearchException elasticsearchRequestFailed(ElasticsearchRequest request, ElasticsearchResponse response, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response)), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchBulkedRequestFailed$str() {
        return elasticsearchBulkedRequestFailed;
    }

    @Override
    public final SearchException elasticsearchBulkedRequestFailed(JsonObject requestMetadata, JsonObject response, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response)), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchRequestTimeout$str() {
        return elasticsearchRequestTimeout;
    }

    @Override
    public final SearchException elasticsearchRequestTimeout() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestTimeout$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return interruptedWhileWaitingForRequestCompletion;
    }

    @Override
    public final SearchException interruptedWhileWaitingForRequestCompletion(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.interruptedWhileWaitingForRequestCompletion$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchMappingCreationFailed$str() {
        return elasticsearchMappingCreationFailed;
    }

    @Override
    public final SearchException elasticsearchMappingCreationFailed(String indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchMappingCreationFailed$str(), indexName, causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIndexStatus$str() {
        return invalidIndexStatus;
    }

    @Override
    public final SearchException invalidIndexStatus(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedIndexStatus$str() {
        return unexpectedIndexStatus;
    }

    @Override
    public final SearchException unexpectedIndexStatus(String indexName, String expected, String timeoutAndUnit, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedIndexStatus$str(), indexName, expected, timeoutAndUnit), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchMappingRetrievalForValidationFailed$str() {
        return elasticsearchMappingRetrievalForValidationFailed;
    }

    @Override
    public final SearchException elasticsearchMappingRetrievalForValidationFailed(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchMappingRetrievalForValidationFailed$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String schemaUpdateFailed$str() {
        return schemaUpdateFailed;
    }

    @Override
    public final SearchException schemaUpdateFailed(Object indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.schemaUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexMissing$str() {
        return indexMissing;
    }

    @Override
    public final SearchException indexMissing(Object indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexMissing$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executingElasticsearchQuery(String path, Map<String, String> parameters, String bodyParts) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executingElasticsearchQuery$str(), (Object)path, parameters, (Object)bodyParts);
    }

    protected String executingElasticsearchQuery$str() {
        return executingElasticsearchQuery;
    }

    protected String tokenizerNamingConflict$str() {
        return tokenizerNamingConflict;
    }

    @Override
    public final SearchException tokenizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenizerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String charFilterNamingConflict$str() {
        return charFilterNamingConflict;
    }

    @Override
    public final SearchException charFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.charFilterNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenFilterNamingConflict$str() {
        return tokenFilterNamingConflict;
    }

    @Override
    public final SearchException tokenFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenFilterNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchSettingsUpdateFailed$str() {
        return elasticsearchSettingsUpdateFailed;
    }

    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(Object indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchSettingsUpdateFailed$str(), indexName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchIndexSettingsRetrievalForValidationFailed$str() {
        return elasticsearchIndexSettingsRetrievalForValidationFailed;
    }

    @Override
    public final SearchException elasticsearchIndexSettingsRetrievalForValidationFailed(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexSettingsRetrievalForValidationFailed$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void closedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.closedIndex$str(), indexName);
    }

    protected String closedIndex$str() {
        return closedIndex;
    }

    @Override
    public final void openedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.openedIndex$str(), indexName);
    }

    protected String openedIndex$str() {
        return openedIndex;
    }

    @Override
    public final void usingPasswordOverHttp(String serverUris) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingPasswordOverHttp$str(), (Object)serverUris);
    }

    protected String usingPasswordOverHttp$str() {
        return usingPasswordOverHttp;
    }

    protected String analyzerNamingConflict$str() {
        return analyzerNamingConflict;
    }

    @Override
    public final SearchException analyzerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return unableToApplyAnalysisConfiguration;
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return invalidElasticsearchAnalyzerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchAnalyzerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTokenizerDefinition$str() {
        return invalidElasticsearchTokenizerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenizerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchCharFilterDefinition$str() {
        return invalidElasticsearchCharFilterDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchCharFilterDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return invalidElasticsearchTokenFilterDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenFilterDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToDetectElasticsearchVersion$str() {
        return failedToDetectElasticsearchVersion;
    }

    @Override
    public final SearchException failedToDetectElasticsearchVersion(Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToDetectElasticsearchVersion$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedElasticsearchVersion$str() {
        return unsupportedElasticsearchVersion;
    }

    @Override
    public final SearchException unsupportedElasticsearchVersion(ElasticsearchVersion version) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedElasticsearchVersion$str(), version));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, int bodyParts, long timeInMs, int responseStatusCode, String responseStatusMessage) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executedRequest7$str(), new Object[]{method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage});
    }

    protected String executedRequest7$str() {
        return executedRequest7;
    }

    @Override
    public final void unknownElasticsearchVersion(ElasticsearchVersion version) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownElasticsearchVersion$str(), (Object)version);
    }

    protected String unknownElasticsearchVersion$str() {
        return unknownElasticsearchVersion;
    }

    protected String normalizerNamingConflict$str() {
        return normalizerNamingConflict;
    }

    @Override
    public final SearchException normalizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToParseElasticsearchResponse$str() {
        return failedToParseElasticsearchResponse;
    }

    @Override
    public final SearchException failedToParseElasticsearchResponse(int statusCode, String statusPhrase, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToParseElasticsearchResponse$str(), statusCode, statusPhrase), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchResponseIndicatesFailure$str() {
        return elasticsearchResponseIndicatesFailure;
    }

    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseIndicatesFailure$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String threadInterruptedWhileSubmittingChangeset$str() {
        return threadInterruptedWhileSubmittingChangeset;
    }

    @Override
    public final SearchException threadInterruptedWhileSubmittingChangeset(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.threadInterruptedWhileSubmittingChangeset$str(), orchestratorName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String orchestratorShutDownBeforeSubmittingChangeset$str() {
        return orchestratorShutDownBeforeSubmittingChangeset;
    }

    @Override
    public final SearchException orchestratorShutDownBeforeSubmittingChangeset(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.orchestratorShutDownBeforeSubmittingChangeset$str(), orchestratorName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, int bodyParts, long timeInMs, int responseStatusCode, String responseStatusMessage, String requestBodyParts, String responseBody) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executedRequest9$str(), new Object[]{method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody});
    }

    protected String executedRequest9$str() {
        return executedRequest9;
    }

    protected String cannotMixElasticsearchSearchScopeWithOtherType$str() {
        return cannotMixElasticsearchSearchScopeWithOtherType;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchScopeWithOtherType(IndexSearchScopeBuilder baseScope, ElasticsearchIndexManager elasticsearchIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchScopeWithOtherBackend$str() {
        return cannotMixElasticsearchSearchScopeWithOtherBackend;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchScopeWithOtherBackend(IndexSearchScopeBuilder baseScope, ElasticsearchIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return unknownFieldForSearch;
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchExtensionOnUnknownType$str() {
        return elasticsearchExtensionOnUnknownType;
    }

    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchExtensionOnUnknownType$str(), context));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return cannotMixElasticsearchSearchQueryWithOtherPredicates;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonObjectFieldForNestedQuery$str() {
        return nonObjectFieldForNestedQuery;
    }

    @Override
    public final SearchException nonObjectFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonNestedFieldForNestedQuery$str() {
        return nonNestedFieldForNestedQuery;
    }

    @Override
    public final SearchException nonNestedFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return cannotMixElasticsearchSearchSortWithOtherSorts;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return multiTenancyRequiredButNotSupportedByBackend;
    }

    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(String indexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return invalidMultiTenancyStrategyName;
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return tenantIdProvidedButMultiTenancyDisabled;
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(String tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return multiTenancyEnabledButNoTenantIdProvided;
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientUnwrappingWithUnkownType$str() {
        return clientUnwrappingWithUnkownType;
    }

    @Override
    public final SearchException clientUnwrappingWithUnkownType(Class<?> requestedClass, Class<?> actualClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.clientUnwrappingWithUnkownType$str(), requestedClass, actualClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return backendUnwrappingWithUnknownType;
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return indexSchemaNodeNameConflict;
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), name), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rangePredicatesNotSupportedByGeoPoint$str() {
        return rangePredicatesNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException rangePredicatesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangePredicatesNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String matchPredicatesNotSupportedByGeoPoint$str() {
        return matchPredicatesNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException matchPredicatesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.matchPredicatesNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return invalidFieldForDocumentElement;
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchResponseMissingData$str() {
        return elasticsearchResponseMissingData;
    }

    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.elasticsearchResponseMissingData$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return spatialPredicatesNotSupportedByFieldType;
    }

    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.spatialPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distanceOperationsNotSupportedByFieldType$str() {
        return distanceOperationsNotSupportedByFieldType;
    }

    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.distanceOperationsNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return minimumShouldMatchConflictingConstraints;
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ceiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ceiling));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateNormalizedIndexNames$str() {
        return duplicateNormalizedIndexNames;
    }

    @Override
    public final SearchException duplicateNormalizedIndexNames(String firstHibernateSearchIndexName, String secondHibernateSearchIndexName, String elasticsearchIndexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateNormalizedIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, elasticsearchIndexName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchResponseUnknownIndexName$str() {
        return elasticsearchResponseUnknownIndexName;
    }

    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(String elasticsearchIndexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return cannotConvertDslParameter;
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return indexManagerUnwrappingWithUnknownType;
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return invalidElasticsearchTypedAnalyzerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return cannotApplyAnalyzerAndNormalizer;
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return cannotUseAnalyzerOnSortableField;
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return analysisComponentParameterConflict;
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, JsonElement value1, JsonElement value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return cannotMixElasticsearchSearchQueryWithOtherProjections;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidProjectionInvalidType$str() {
        return invalidProjectionInvalidType;
    }

    @Override
    public final SearchException invalidProjectionInvalidType(String absoluteFieldPath, Class<?> type, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidProjectionInvalidType$str(), absoluteFieldPath, new ClassFormatter(type)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return traditionalSortNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.traditionalSortNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForPredicate$str() {
        return conflictingFieldTypesForPredicate;
    }

    @Override
    public final SearchException conflictingFieldTypesForPredicate(String absoluteFieldPath, ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForSort$str() {
        return conflictingFieldTypesForSort;
    }

    @Override
    public final SearchException conflictingFieldTypesForSort(String absoluteFieldPath, ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForProjection$str() {
        return conflictingFieldTypesForProjection;
    }

    @Override
    public final SearchException conflictingFieldTypesForProjection(String absoluteFieldPath, ElasticsearchFieldProjectionBuilderFactory component1, ElasticsearchFieldProjectionBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToShutdownBackend$str() {
        return failedToShutdownBackend;
    }

    @Override
    public final SearchException failedToShutdownBackend(Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownBackend$str(), new Object[0]), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return cannotGuessFieldType;
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonProjectableField$str() {
        return nonProjectableField;
    }

    @Override
    public final SearchException nonProjectableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonProjectableField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsortableField$str() {
        return unsortableField;
    }

    @Override
    public final SearchException unsortableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsortableField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingIdentifierTypesForPredicate$str() {
        return conflictingIdentifierTypesForPredicate;
    }

    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(ToDocumentIdentifierValueConverter<?> component1, ToDocumentIdentifierValueConverter<?> component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToShutdownIndexManager$str() {
        return failedToShutdownIndexManager;
    }

    @Override
    public final SearchException failedToShutdownIndexManager(String indexName, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownIndexManager$str(), indexName), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchSkippedBecauseOfPreviousWork$str() {
        return elasticsearchSkippedBecauseOfPreviousWork;
    }

    @Override
    public final SearchException elasticsearchSkippedBecauseOfPreviousWork(Throwable skippingCause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchSkippedBecauseOfPreviousWork$str(), new Object[0]), skippingCause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIndexLifecycleStrategyName$str() {
        return invalidIndexLifecycleStrategyName;
    }

    @Override
    public final SearchException invalidIndexLifecycleStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexLifecycleStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String textPredicatesNotSupportedByFieldType$str() {
        return textPredicatesNotSupportedByFieldType;
    }

    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.textPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return incompleteFieldDefinition;
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return cannotCreateReferenceMultipleTimes;
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchVersion$str() {
        return invalidElasticsearchVersion;
    }

    @Override
    public final SearchException invalidElasticsearchVersion(String versionString) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchVersion$str(), versionString));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDialectName$str() {
        return invalidDialectName;
    }

    @Override
    public final SearchException invalidDialectName(String normalizedValue, List<String> validValues) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDialectName$str(), normalizedValue, validValues));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedElasticsearchVersion$str() {
        return unexpectedElasticsearchVersion;
    }

    @Override
    public final SearchException unexpectedElasticsearchVersion(ElasticsearchVersion actualVersion, ElasticsearchDialectName appropriateDialectName, ElasticsearchDialectName configuredDialectName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedElasticsearchVersion$str(), new Object[]{actualVersion, appropriateDialectName, configuredDialectName}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

