/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchSearchScopeModel {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<ElasticsearchIndexModel> indexModels;
    private final Set<String> hibernateSearchIndexNames;
    private final Set<URLEncodedString> elasticsearchIndexNames;

    public ElasticsearchSearchScopeModel(Set<ElasticsearchIndexModel> indexModels) {
        this.indexModels = indexModels;
        this.hibernateSearchIndexNames = indexModels.stream().map(ElasticsearchIndexModel::getHibernateSearchIndexName).collect(Collectors.toSet());
        this.elasticsearchIndexNames = indexModels.stream().map(ElasticsearchIndexModel::getElasticsearchIndexName).collect(Collectors.toSet());
    }

    public Set<String> getHibernateSearchIndexNames() {
        return this.hibernateSearchIndexNames;
    }

    public Set<URLEncodedString> getElasticsearchIndexNames() {
        return this.elasticsearchIndexNames;
    }

    public EventContext getIndexesEventContext() {
        return EventContexts.fromIndexNames(this.hibernateSearchIndexNames);
    }

    public ToDocumentIdentifierValueConverter<?> getIdDslConverter() {
        Iterator<ElasticsearchIndexModel> iterator = this.indexModels.iterator();
        ElasticsearchIndexModel indexModelForSelectedIdConverter = iterator.next();
        ToDocumentIdentifierValueConverter<?> selectedIdConverter = indexModelForSelectedIdConverter.getIdDslConverter();
        while (iterator.hasNext()) {
            ElasticsearchIndexModel indexModel = iterator.next();
            ToDocumentIdentifierValueConverter<?> idConverter = indexModel.getIdDslConverter();
            if (selectedIdConverter.isCompatibleWith(idConverter)) continue;
            throw log.conflictingIdentifierTypesForPredicate(selectedIdConverter, idConverter, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedIdConverter.getHibernateSearchIndexName(), indexModel.getHibernateSearchIndexName()}));
        }
        return selectedIdConverter;
    }

    public <T> T getSchemaNodeComponent(String absoluteFieldPath, IndexSchemaFieldNodeComponentRetrievalStrategy<T> componentRetrievalStrategy) {
        return this.getSchemaNodeComponent(absoluteFieldPath, componentRetrievalStrategy, DslConverter.ENABLED);
    }

    public <T> T getSchemaNodeComponent(String absoluteFieldPath, IndexSchemaFieldNodeComponentRetrievalStrategy<T> componentRetrievalStrategy, DslConverter dslConverter) {
        ElasticsearchIndexModel indexModelForSelectedSchemaNode = null;
        ElasticsearchIndexSchemaFieldNode<?> selectedSchemaNode = null;
        Object selectedComponent = null;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            ElasticsearchIndexSchemaFieldNode<?> schemaNode = indexModel.getFieldNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            T component = componentRetrievalStrategy.extractComponent(schemaNode);
            if (selectedSchemaNode == null) {
                selectedSchemaNode = schemaNode;
                indexModelForSelectedSchemaNode = indexModel;
                selectedComponent = component;
                continue;
            }
            if (componentRetrievalStrategy.areCompatible(selectedComponent, component, dslConverter)) continue;
            throw componentRetrievalStrategy.createCompatibilityException(absoluteFieldPath, selectedComponent, component, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedSchemaNode.getHibernateSearchIndexName(), indexModel.getHibernateSearchIndexName()}));
        }
        if (selectedSchemaNode == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
        return selectedComponent;
    }

    public void checkNestedField(String absoluteFieldPath) {
        ElasticsearchIndexSchemaFieldNode<?> schemaNode;
        boolean found = false;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            schemaNode = indexModel.getObjectNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            found = true;
            if (ObjectFieldStorage.NESTED.equals((Object)((ElasticsearchIndexSchemaObjectNode)((Object)schemaNode)).getStorage())) continue;
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
        }
        if (!found) {
            for (ElasticsearchIndexModel indexModel : this.indexModels) {
                schemaNode = indexModel.getFieldNode(absoluteFieldPath);
                if (schemaNode == null) continue;
                throw log.nonObjectFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
            }
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
    }
}

