/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchBooleanJunctionPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchAllPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchIdPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchNestedPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSimpleQueryStringPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchUserProvidedJsonPredicateContributor;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanJunctionPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchSearchPredicateBuilderFactoryImpl
implements ElasticsearchSearchPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final PredicateBuilderFactoryRetrievalStrategy PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new PredicateBuilderFactoryRetrievalStrategy();
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchScopeModel scopeModel;

    public ElasticsearchSearchPredicateBuilderFactoryImpl(ElasticsearchSearchContext searchContext, ElasticsearchSearchScopeModel scopeModel) {
        this.searchContext = searchContext;
        this.scopeModel = scopeModel;
    }

    public SearchPredicate toSearchPredicate(ElasticsearchSearchPredicateBuilder builder) {
        return new ElasticsearchSearchPredicate(builder);
    }

    public ElasticsearchSearchPredicateBuilder toImplementation(SearchPredicate predicate) {
        if (!(predicate instanceof ElasticsearchSearchPredicate)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherPredicates(predicate);
        }
        return (ElasticsearchSearchPredicate)predicate;
    }

    public void contribute(ElasticsearchSearchPredicateCollector collector, ElasticsearchSearchPredicateBuilder builder) {
        collector.collectPredicate(builder.build(collector.getRootPredicateContext()));
    }

    public MatchAllPredicateBuilder<ElasticsearchSearchPredicateBuilder> matchAll() {
        return new ElasticsearchMatchAllPredicateBuilder();
    }

    public MatchIdPredicateBuilder<ElasticsearchSearchPredicateBuilder> id() {
        return new ElasticsearchMatchIdPredicateBuilder(this.searchContext, this.scopeModel.getIdDslConverter());
    }

    public BooleanJunctionPredicateBuilder<ElasticsearchSearchPredicateBuilder> bool() {
        return new ElasticsearchBooleanJunctionPredicateBuilder();
    }

    public MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> match(String absoluteFieldPath, DslConverter dslConverter) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY, dslConverter).createMatchPredicateBuilder(this.searchContext, absoluteFieldPath, dslConverter);
    }

    public RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> range(String absoluteFieldPath, DslConverter dslConverter) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY, dslConverter).createRangePredicateBuilder(this.searchContext, absoluteFieldPath, dslConverter);
    }

    public PhrasePredicateBuilder<ElasticsearchSearchPredicateBuilder> phrase(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY, DslConverter.DISABLED).createPhrasePredicateBuilder(absoluteFieldPath);
    }

    public WildcardPredicateBuilder<ElasticsearchSearchPredicateBuilder> wildcard(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY, DslConverter.DISABLED).createWildcardPredicateBuilder(absoluteFieldPath);
    }

    public SimpleQueryStringPredicateBuilder<ElasticsearchSearchPredicateBuilder> simpleQueryString() {
        return new ElasticsearchSimpleQueryStringPredicateBuilder(this.scopeModel);
    }

    public SpatialWithinCirclePredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinCircle(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinCirclePredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinPolygonPredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinPolygon(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinPolygonPredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinBoundingBoxPredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinBoundingBox(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinBoundingBoxPredicateBuilder(absoluteFieldPath);
    }

    public NestedPredicateBuilder<ElasticsearchSearchPredicateBuilder> nested(String absoluteFieldPath) {
        this.scopeModel.checkNestedField(absoluteFieldPath);
        return new ElasticsearchNestedPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public ElasticsearchSearchPredicateBuilder fromJsonString(String jsonString) {
        return new ElasticsearchUserProvidedJsonPredicateContributor((JsonObject)this.searchContext.getUserFacingGson().fromJson(jsonString, JsonObject.class));
    }

    private static class PredicateBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<ElasticsearchFieldPredicateBuilderFactory> {
        private PredicateBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public ElasticsearchFieldPredicateBuilderFactory extractComponent(ElasticsearchIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.getPredicateBuilderFactory();
        }

        @Override
        public boolean areCompatible(ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2, DslConverter dslConverter) {
            return component1.isDslCompatibleWith(component2, dslConverter);
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForPredicate(absoluteFieldPath, component1, component2, context);
        }
    }
}

