/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

class ElasticsearchFieldProjection<F, T>
implements ElasticsearchSearchProjection<F, T> {
    private static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private final String absoluteFieldPath;
    private final UnknownTypeJsonAccessor hitFieldValueAccessor;
    private final FromDocumentFieldValueConverter<? super F, T> converter;
    private final ElasticsearchFieldCodec<F> codec;

    ElasticsearchFieldProjection(String absoluteFieldPath, FromDocumentFieldValueConverter<? super F, T> converter, ElasticsearchFieldCodec<F> codec) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.hitFieldValueAccessor = HIT_SOURCE_ACCESSOR.path(absoluteFieldPath);
        this.converter = converter;
        this.codec = codec;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        JsonPrimitive fieldPathJson;
        JsonArray source = REQUEST_SOURCE_ACCESSOR.getOrCreate(requestBody, JsonArray::new);
        if (!source.contains((JsonElement)(fieldPathJson = new JsonPrimitive(this.absoluteFieldPath)))) {
            source.add((JsonElement)fieldPathJson);
        }
    }

    @Override
    public F extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        Optional fieldValue = this.hitFieldValueAccessor.get(hit);
        if (fieldValue.isPresent()) {
            return this.codec.decode((JsonElement)fieldValue.get());
        }
        return null;
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, F extractedData, SearchProjectionTransformContext context) {
        FromDocumentFieldValueConvertContext convertContext = context.getFromDocumentFieldValueConvertContext();
        return (T)this.converter.convert(extractedData, convertContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append("]");
        return sb.toString();
    }
}

