/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchIndexSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.query.spi.IndexSearchQuery;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

class ElasticsearchSearchQueryBuilder<T>
implements SearchQueryBuilder<T, ElasticsearchSearchQueryElementCollector> {
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final Set<URLEncodedString> indexNames;
    private final SessionContextImplementor sessionContext;
    private final Set<String> routingKeys;
    private final ElasticsearchSearchQueryElementCollector elementCollector;
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final ElasticsearchSearchProjection<?, T> rootProjection;

    ElasticsearchSearchQueryBuilder(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory, ElasticsearchWorkOrchestrator queryOrchestrator, MultiTenancyStrategy multiTenancyStrategy, Set<URLEncodedString> indexNames, SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, ElasticsearchSearchProjection<?, T> rootProjection) {
        this.workFactory = workFactory;
        this.searchResultExtractorFactory = searchResultExtractorFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.indexNames = indexNames;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.elementCollector = new ElasticsearchSearchQueryElementCollector(sessionContext);
        this.projectionHitMapper = projectionHitMapper;
        this.rootProjection = rootProjection;
    }

    public ElasticsearchSearchQueryElementCollector getQueryElementCollector() {
        return this.elementCollector;
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    private IndexSearchQuery<T> build() {
        JsonArray jsonSort;
        JsonObject payload = new JsonObject();
        JsonObject jsonQuery = this.getJsonQuery();
        if (jsonQuery != null) {
            payload.add("query", (JsonElement)jsonQuery);
        }
        if ((jsonSort = this.elementCollector.toJsonSort()) != null) {
            payload.add("sort", (JsonElement)jsonSort);
        }
        SearchProjectionExtractContext searchProjectionExecutionContext = this.elementCollector.toSearchProjectionExecutionContext();
        this.rootProjection.contributeRequest(payload, searchProjectionExecutionContext);
        ElasticsearchSearchResultExtractor<T> searchResultExtractor = this.searchResultExtractorFactory.createResultExtractor(this.projectionHitMapper, this.rootProjection, searchProjectionExecutionContext);
        return new ElasticsearchIndexSearchQuery<T>(this.workFactory, this.queryOrchestrator, this.indexNames, this.sessionContext, this.routingKeys, payload, searchResultExtractor);
    }

    private JsonObject getJsonQuery() {
        return this.multiTenancyStrategy.decorateJsonQuery(this.elementCollector.toJsonPredicate(), this.sessionContext.getTenantIdentifier());
    }

    public <Q> Q build(Function<IndexSearchQuery<T>, Q> searchQueryWrapperFactory) {
        return searchQueryWrapperFactory.apply(this.build());
    }
}

