/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchIndexFieldTypeFactoryContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchJsonStringIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchBooleanIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchByteIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchDoubleIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchFloatIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchGeoPointIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchInstantIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIntegerIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchJsonStringIndexFieldTypeContextImpl;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalDateIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalDateTimeIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalTimeIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLongIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchMonthDayIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchOffsetDateTimeIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchOffsetTimeIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchShortIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchStringIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchYearIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchYearMonthIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchZonedDateTimeIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.format.impl.ElasticsearchDefaultFieldFormatProvider;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexFieldTypeFactoryContextImpl
implements ElasticsearchIndexFieldTypeFactoryContext,
ElasticsearchIndexFieldTypeBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final Gson userFacingGson;
    private final ElasticsearchDefaultFieldFormatProvider defaultFieldFormatProvider;

    public ElasticsearchIndexFieldTypeFactoryContextImpl(EventContext eventContext, Gson userFacingGson, ElasticsearchDefaultFieldFormatProvider defaultFieldFormatProvider) {
        this.eventContext = eventContext;
        this.userFacingGson = userFacingGson;
        this.defaultFieldFormatProvider = defaultFieldFormatProvider;
    }

    public <F> StandardIndexFieldTypeContext<?, F> as(Class<F> inputType) {
        if (String.class.equals(inputType)) {
            return this.asString();
        }
        if (Integer.class.equals(inputType)) {
            return this.asInteger();
        }
        if (Long.class.equals(inputType)) {
            return this.asLong();
        }
        if (Boolean.class.equals(inputType)) {
            return this.asBoolean();
        }
        if (Byte.class.equals(inputType)) {
            return this.asByte();
        }
        if (Short.class.equals(inputType)) {
            return this.asShort();
        }
        if (Float.class.equals(inputType)) {
            return this.asFloat();
        }
        if (Double.class.equals(inputType)) {
            return this.asDouble();
        }
        if (LocalDate.class.equals(inputType)) {
            return this.asLocalDate();
        }
        if (LocalDateTime.class.equals(inputType)) {
            return this.asLocalDateTime();
        }
        if (LocalTime.class.equals(inputType)) {
            return this.asLocalTime();
        }
        if (Instant.class.equals(inputType)) {
            return this.asInstant();
        }
        if (ZonedDateTime.class.equals(inputType)) {
            return this.asZonedDateTime();
        }
        if (Year.class.equals(inputType)) {
            return this.asYear();
        }
        if (YearMonth.class.equals(inputType)) {
            return this.asYearMonth();
        }
        if (MonthDay.class.equals(inputType)) {
            return this.asMonthDay();
        }
        if (OffsetDateTime.class.equals(inputType)) {
            return this.asOffsetDateTime();
        }
        if (OffsetTime.class.equals(inputType)) {
            return this.asOffsetTime();
        }
        if (GeoPoint.class.equals(inputType)) {
            return this.asGeoPoint();
        }
        throw log.cannotGuessFieldType(inputType, this.getEventContext());
    }

    public StringIndexFieldTypeContext<?> asString() {
        return new ElasticsearchStringIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Integer> asInteger() {
        return new ElasticsearchIntegerIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Long> asLong() {
        return new ElasticsearchLongIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Boolean> asBoolean() {
        return new ElasticsearchBooleanIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Byte> asByte() {
        return new ElasticsearchByteIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Short> asShort() {
        return new ElasticsearchShortIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Float> asFloat() {
        return new ElasticsearchFloatIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Double> asDouble() {
        return new ElasticsearchDoubleIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalDate> asLocalDate() {
        return new ElasticsearchLocalDateIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalDateTime> asLocalDateTime() {
        return new ElasticsearchLocalDateTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalTime> asLocalTime() {
        return new ElasticsearchLocalTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Instant> asInstant() {
        return new ElasticsearchInstantIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, ZonedDateTime> asZonedDateTime() {
        return new ElasticsearchZonedDateTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Year> asYear() {
        return new ElasticsearchYearIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, YearMonth> asYearMonth() {
        return new ElasticsearchYearMonthIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, MonthDay> asMonthDay() {
        return new ElasticsearchMonthDayIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, OffsetDateTime> asOffsetDateTime() {
        return new ElasticsearchOffsetDateTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, OffsetTime> asOffsetTime() {
        return new ElasticsearchOffsetTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, GeoPoint> asGeoPoint() {
        return new ElasticsearchGeoPointIndexFieldTypeContext(this);
    }

    @Override
    public ElasticsearchJsonStringIndexFieldTypeContext<?> asJsonString(String mappingJsonString) {
        return new ElasticsearchJsonStringIndexFieldTypeContextImpl((ElasticsearchIndexFieldTypeBuildContext)this, mappingJsonString);
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public Gson getUserFacingGson() {
        return this.userFacingGson;
    }

    @Override
    public ElasticsearchDefaultFieldFormatProvider getDefaultFieldFormatProvider() {
        return this.defaultFieldFormatProvider;
    }
}

