/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchRangePredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.AbstractElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardMatchPredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;

public class ElasticsearchStandardFieldPredicateBuilderFactory<F>
extends AbstractElasticsearchFieldPredicateBuilderFactory {
    protected final ToDocumentFieldValueConverter<?, ? extends F> converter;
    protected final ToDocumentFieldValueConverter<F, ? extends F> rawConverter;
    protected final ElasticsearchFieldCodec<F> codec;

    public ElasticsearchStandardFieldPredicateBuilderFactory(ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, ElasticsearchFieldCodec<F> codec) {
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    @Override
    public boolean isDslCompatibleWith(ElasticsearchFieldPredicateBuilderFactory other, DslConverter dslConverter) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldPredicateBuilderFactory castedOther = (ElasticsearchStandardFieldPredicateBuilderFactory)other;
        if (!this.codec.isCompatibleWith(castedOther.codec)) {
            return false;
        }
        return !dslConverter.isEnabled() || this.converter.isCompatibleWith(castedOther.converter);
    }

    @Override
    public MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> createMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, DslConverter dslConverter) {
        return new ElasticsearchStandardMatchPredicateBuilder<F>(searchContext, absoluteFieldPath, this.getConverter(dslConverter), this.codec);
    }

    @Override
    public RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> createRangePredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, DslConverter dslConverter) {
        return new ElasticsearchRangePredicateBuilder<F>(searchContext, absoluteFieldPath, this.getConverter(dslConverter), this.codec);
    }

    protected final ToDocumentFieldValueConverter<?, ? extends F> getConverter(DslConverter dslConverter) {
        return dslConverter.isEnabled() ? this.converter : this.rawConverter;
    }
}

