/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardMatchPredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class ElasticsearchTextMatchPredicateBuilder
extends ElasticsearchStandardMatchPredicateBuilder<String> {
    private static final JsonAccessor<Integer> FUZZINESS_ACCESSOR = JsonAccessor.root().property("fuzziness").asInteger();
    private static final JsonAccessor<Integer> PREFIX_LENGTH_ACCESSOR = JsonAccessor.root().property("prefix_length").asInteger();
    private Integer fuzziness;
    private Integer prefixLength;

    ElasticsearchTextMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends String> dslToIndexConverter, ElasticsearchFieldCodec<String> codec) {
        super(searchContext, absoluteFieldPath, dslToIndexConverter, codec);
    }

    @Override
    public void fuzzy(int maxEditDistance, int exactPrefixLength) {
        this.fuzziness = maxEditDistance;
        this.prefixLength = exactPrefixLength;
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        if (this.fuzziness != null) {
            FUZZINESS_ACCESSOR.set(innerObject, this.fuzziness);
        }
        if (this.prefixLength != null) {
            PREFIX_LENGTH_ACCESSOR.set(innerObject, this.prefixLength);
        }
        return super.doBuild(context, outerObject, innerObject);
    }
}

