/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.projection.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDistanceToFieldProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionConverter;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchGeoPointFieldProjectionBuilderFactory
implements ElasticsearchFieldProjectionBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean projectable;
    private final FromDocumentFieldValueConverter<? super GeoPoint, ?> converter;
    private final FromDocumentFieldValueConverter<? super GeoPoint, GeoPoint> rawConverter;
    private final ElasticsearchFieldCodec<GeoPoint> codec;

    public ElasticsearchGeoPointFieldProjectionBuilderFactory(boolean projectable, FromDocumentFieldValueConverter<? super GeoPoint, ?> converter, FromDocumentFieldValueConverter<? super GeoPoint, GeoPoint> rawConverter, ElasticsearchFieldCodec<GeoPoint> codec) {
        this.projectable = projectable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    @Override
    public <T> FieldProjectionBuilder<T> createFieldValueProjectionBuilder(String absoluteFieldPath, Class<T> expectedType, ProjectionConverter projectionConverter) {
        ElasticsearchGeoPointFieldProjectionBuilderFactory.checkProjectable(absoluteFieldPath, this.projectable);
        FromDocumentFieldValueConverter<? super GeoPoint, ?> requestConverter = this.getConverter(projectionConverter);
        if (!requestConverter.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidProjectionInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return new ElasticsearchFieldProjectionBuilder(absoluteFieldPath, requestConverter, this.codec);
    }

    @Override
    public DistanceToFieldProjectionBuilder createDistanceProjectionBuilder(String absoluteFieldPath, GeoPoint center) {
        ElasticsearchGeoPointFieldProjectionBuilderFactory.checkProjectable(absoluteFieldPath, this.projectable);
        return new ElasticsearchDistanceToFieldProjectionBuilder(absoluteFieldPath, center);
    }

    @Override
    public boolean isDslCompatibleWith(ElasticsearchFieldProjectionBuilderFactory obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ElasticsearchGeoPointFieldProjectionBuilderFactory.class) {
            return false;
        }
        ElasticsearchGeoPointFieldProjectionBuilderFactory other = (ElasticsearchGeoPointFieldProjectionBuilderFactory)obj;
        return this.projectable == other.projectable && this.converter.isCompatibleWith(other.converter) && this.codec.isCompatibleWith(other.codec);
    }

    private static void checkProjectable(String absoluteFieldPath, boolean projectable) {
        if (!projectable) {
            throw log.nonProjectableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    private FromDocumentFieldValueConverter<? super GeoPoint, ?> getConverter(ProjectionConverter projectionConverter) {
        return projectionConverter.isEnabled() ? this.converter : this.rawConverter;
    }
}

