/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchDistanceSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchGeoPointFieldSortBuilderFactory
implements ElasticsearchFieldSortBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean sortable;

    public ElasticsearchGeoPointFieldSortBuilderFactory(boolean sortable) {
        this.sortable = sortable;
    }

    @Override
    public FieldSortBuilder<ElasticsearchSearchSortBuilder> createFieldSortBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, DslConverter dslConverter) {
        throw log.traditionalSortNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public DistanceSortBuilder<ElasticsearchSearchSortBuilder> createDistanceSortBuilder(String absoluteFieldPath, GeoPoint center) {
        ElasticsearchGeoPointFieldSortBuilderFactory.checkSortable(absoluteFieldPath, this.sortable);
        return new ElasticsearchDistanceSortBuilder(absoluteFieldPath, center);
    }

    @Override
    public boolean isDslCompatibleWith(ElasticsearchFieldSortBuilderFactory obj, DslConverter converter) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ElasticsearchGeoPointFieldSortBuilderFactory other = (ElasticsearchGeoPointFieldSortBuilderFactory)obj;
        return other.sortable == this.sortable;
    }

    private static void checkSortable(String absoluteFieldPath, boolean sortable) {
        if (!sortable) {
            throw log.unsortableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

