/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchFieldSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchStandardFieldSortBuilderFactory<F>
implements ElasticsearchFieldSortBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean sortable;
    private final ToDocumentFieldValueConverter<?, ? extends F> converter;
    private final ToDocumentFieldValueConverter<F, ? extends F> rawConverter;
    private final ElasticsearchFieldCodec<F> codec;

    public ElasticsearchStandardFieldSortBuilderFactory(boolean sortable, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, ElasticsearchFieldCodec<F> codec) {
        this.sortable = sortable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    @Override
    public FieldSortBuilder<ElasticsearchSearchSortBuilder> createFieldSortBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, DslConverter dslConverter) {
        ElasticsearchStandardFieldSortBuilderFactory.checkSortable(absoluteFieldPath, this.sortable);
        return new ElasticsearchFieldSortBuilder<F>(searchContext, absoluteFieldPath, this.getConverter(dslConverter), this.codec);
    }

    @Override
    public DistanceSortBuilder<ElasticsearchSearchSortBuilder> createDistanceSortBuilder(String absoluteFieldPath, GeoPoint center) {
        throw log.distanceOperationsNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public boolean isDslCompatibleWith(ElasticsearchFieldSortBuilderFactory obj, DslConverter dslConverter) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ElasticsearchStandardFieldSortBuilderFactory.class) {
            return false;
        }
        ElasticsearchStandardFieldSortBuilderFactory other = (ElasticsearchStandardFieldSortBuilderFactory)obj;
        if (this.sortable != other.sortable || !this.codec.isCompatibleWith(other.codec)) {
            return false;
        }
        return !dslConverter.isEnabled() || this.converter.isCompatibleWith(other.converter);
    }

    private static void checkSortable(String absoluteFieldPath, boolean sortable) {
        if (!sortable) {
            throw log.unsortableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    private ToDocumentFieldValueConverter<?, ? extends F> getConverter(DslConverter dslConverter) {
        return dslConverter.isEnabled() ? this.converter : this.rawConverter;
    }
}

