/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.ScrollWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class ScrollWork<T>
extends AbstractSimpleElasticsearchWork<ElasticsearchLoadableSearchResult<T>> {
    private final ElasticsearchSearchResultExtractor<T> resultExtractor;

    protected ScrollWork(Builder<T> builder) {
        super(builder);
        this.resultExtractor = ((Builder)builder).resultExtractor;
    }

    @Override
    protected ElasticsearchLoadableSearchResult<T> generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.getBody();
        return this.resultExtractor.extract(body);
    }

    public static class Builder<T>
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<Builder<T>>
    implements ScrollWorkBuilder<T> {
        private final String scrollId;
        private final String scrollTimeout;
        private final ElasticsearchSearchResultExtractor<T> resultExtractor;

        public Builder(String scrollId, String scrollTimeout, ElasticsearchSearchResultExtractor<T> resultExtractor) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.scrollId = scrollId;
            this.scrollTimeout = scrollTimeout;
            this.resultExtractor = resultExtractor;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            JsonObject body = new JsonObject();
            body.addProperty("scroll_id", this.scrollId);
            body.addProperty("scroll", this.scrollTimeout);
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(Paths._SEARCH).pathComponent(Paths.SCROLL).body(body);
            return builder.build();
        }

        @Override
        public ScrollWork<T> build() {
            return new ScrollWork(this);
        }
    }
}

