/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.cfg;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchVersion {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:-(\\w+))?");
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public static ElasticsearchVersion of(String propertyValue) {
        String normalizedVersion = propertyValue.trim().toLowerCase(Locale.ROOT);
        Matcher matcher = pattern.matcher(normalizedVersion);
        if (!matcher.matches()) {
            throw log.invalidElasticsearchVersion(normalizedVersion);
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        String micro = matcher.group(3);
        String qualifier = matcher.group(4);
        return new ElasticsearchVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(micro), qualifier);
    }

    private ElasticsearchVersion(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro + (this.qualifier == null ? "" : "-" + this.qualifier);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }
}

