/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchClientProvider;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSharedWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorProvider;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchIndexFieldTypeFactoryContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryContextProvider;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.engine.common.spi.LogErrorHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchBackendImpl
implements BackendImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchClientProvider clientProvider;
    private final String name;
    private final ElasticsearchWorkOrchestratorProvider orchestratorProvider;
    private final ElasticsearchIndexFieldTypeFactoryContextProvider typeFactoryContextProvider;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchSharedWorkOrchestrator queryOrchestrator;
    private final Map<String, String> hibernateSearchIndexNamesByElasticsearchIndexNames = new ConcurrentHashMap<String, String>();
    private final EventContext eventContext;
    private final IndexingBackendContext indexingContext;
    private final SearchBackendContext searchContext;

    ElasticsearchBackendImpl(ElasticsearchClientProvider clientProvider, GsonProvider dialectSpecificGsonProvider, String name, ElasticsearchWorkBuilderFactory workFactory, ElasticsearchIndexFieldTypeFactoryContextProvider typeFactoryContextProvider, ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory, Gson userFacingGson, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy) {
        this.clientProvider = clientProvider;
        this.name = name;
        this.orchestratorProvider = new ElasticsearchWorkOrchestratorProvider("Elasticsearch parallel work orchestrator for backend " + name, clientProvider, dialectSpecificGsonProvider, workFactory, (ErrorHandler)new LogErrorHandler());
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.queryOrchestrator = this.orchestratorProvider.createParallelOrchestrator("Elasticsearch query orchestrator for backend " + name);
        this.typeFactoryContextProvider = typeFactoryContextProvider;
        this.eventContext = EventContexts.fromBackendName((String)name);
        this.indexingContext = new IndexingBackendContext(this.eventContext, workFactory, multiTenancyStrategy, this.orchestratorProvider);
        this.searchContext = new SearchBackendContext(this.eventContext, workFactory, searchResultExtractorFactory, userFacingGson, elasticsearchIndexName -> {
            String result = this.hibernateSearchIndexNamesByElasticsearchIndexNames.get(elasticsearchIndexName);
            if (result == null) {
                throw log.elasticsearchResponseUnknownIndexName((String)elasticsearchIndexName, this.eventContext);
            }
            return result;
        }, multiTenancyStrategy, this.queryOrchestrator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.name + "]";
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestrator::close, (Object)this.queryOrchestrator);
            closer.push(ElasticsearchWorkOrchestratorProvider::close, (Object)this.orchestratorProvider);
            closer.push(ElasticsearchClientProvider::onStop, (Object)this.clientProvider);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.eventContext);
        }
    }

    public void start(BackendStartContext context) {
        this.clientProvider.onStart(context.getConfigurationPropertySource());
        this.orchestratorProvider.start();
        this.queryOrchestrator.start();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, ElasticsearchBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    @Override
    public <T> T getClient(Class<T> clientClass) {
        return this.clientProvider.get().unwrap(clientClass);
    }

    public IndexManagerBuilder<ElasticsearchDocumentObjectBuilder> createIndexManagerBuilder(String hibernateSearchIndexName, boolean multiTenancyEnabled, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(hibernateSearchIndexName, this.eventContext);
        }
        String elasticsearchIndexName = ElasticsearchIndexNameNormalizer.normalize(hibernateSearchIndexName);
        String existingHibernateSearchIndexName = this.hibernateSearchIndexNamesByElasticsearchIndexNames.putIfAbsent(elasticsearchIndexName, hibernateSearchIndexName);
        if (existingHibernateSearchIndexName != null) {
            throw log.duplicateNormalizedIndexNames(existingHibernateSearchIndexName, hibernateSearchIndexName, elasticsearchIndexName, this.eventContext);
        }
        EventContext indexEventContext = EventContexts.fromIndexName((String)hibernateSearchIndexName);
        ElasticsearchIndexFieldTypeFactoryContext typeFactoryContext = this.typeFactoryContextProvider.create(indexEventContext);
        ElasticsearchIndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder = new ElasticsearchIndexSchemaRootNodeBuilder(indexEventContext, this.multiTenancyStrategy, typeFactoryContext);
        ElasticsearchIndexSettingsBuilder settingsBuilder = new ElasticsearchIndexSettingsBuilder(this.analysisDefinitionRegistry);
        return new ElasticsearchIndexManagerBuilder(this.indexingContext, this.searchContext, hibernateSearchIndexName, elasticsearchIndexName, indexSchemaRootNodeBuilder, settingsBuilder);
    }
}

