/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaCreatorImpl
implements ElasticsearchSchemaCreator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSchemaAccessor schemaAccessor;

    public ElasticsearchSchemaCreatorImpl(ElasticsearchSchemaAccessor schemaAccessor) {
        this.schemaAccessor = schemaAccessor;
    }

    @Override
    public void createIndex(IndexMetadata indexMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        this.schemaAccessor.createIndex(indexName, indexMetadata.getSettings(), indexMetadata.getMapping());
        this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
    }

    @Override
    public boolean createIndexIfAbsent(IndexMetadata indexMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        boolean created = false;
        if (!this.schemaAccessor.indexExists(indexName)) {
            created = this.schemaAccessor.createIndexIfAbsent(indexName, indexMetadata.getSettings(), indexMetadata.getMapping());
        }
        this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
        return created;
    }

    @Override
    public void checkIndexExists(URLEncodedString indexName, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        if (!this.schemaAccessor.indexExists(indexName)) {
            throw log.indexMissing(indexName);
        }
        this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
    }
}

