/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.engine.backend.index.spi.DocumentContributor;
import org.hibernate.search.engine.backend.index.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;

public class ElasticsearchIndexDocumentWorkExecutor
implements IndexDocumentWorkExecutor<ElasticsearchDocumentObjectBuilder> {
    private final ElasticsearchWorkBuilderFactory factory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final URLEncodedString indexName;
    private final String tenantId;

    ElasticsearchIndexDocumentWorkExecutor(ElasticsearchWorkBuilderFactory factory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, SessionContextImplementor sessionContext) {
        this.factory = factory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String elasticsearchId = this.multiTenancyStrategy.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.getRoutingKey();
        ElasticsearchDocumentObjectBuilder builder = new ElasticsearchDocumentObjectBuilder();
        documentContributor.contribute((Object)builder);
        JsonObject document = builder.build(this.multiTenancyStrategy, this.tenantId, id);
        Object work = this.factory.index(this.indexName, URLEncodedString.fromString(elasticsearchId), routingKey, document).build();
        return this.orchestrator.submit(work);
    }
}

