/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerImpl;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchIndexSearchScope;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.index.spi.IndexSearchScopeBuilder;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.search.dsl.spi.IndexSearchScope;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchIndexSearchScopeBuilder
implements IndexSearchScopeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SearchBackendContext searchBackendContext;
    private final MappingContextImplementor mappingContext;
    private final Set<ElasticsearchIndexManagerImpl> indexManagers = new LinkedHashSet<ElasticsearchIndexManagerImpl>();

    ElasticsearchIndexSearchScopeBuilder(SearchBackendContext searchBackendContext, MappingContextImplementor mappingContext, ElasticsearchIndexManagerImpl indexManager) {
        this.searchBackendContext = searchBackendContext;
        this.mappingContext = mappingContext;
        this.indexManagers.add(indexManager);
    }

    void add(SearchBackendContext searchBackendContext, ElasticsearchIndexManagerImpl indexManager) {
        if (!this.searchBackendContext.equals(searchBackendContext)) {
            throw log.cannotMixElasticsearchSearchScopeWithOtherBackend(this, indexManager, searchBackendContext.getEventContext());
        }
        this.indexManagers.add(indexManager);
    }

    public IndexSearchScope<?> build() {
        Set indexModels = this.indexManagers.stream().map(ElasticsearchIndexManagerImpl::getModel).collect(Collectors.toCollection(LinkedHashSet::new));
        ElasticsearchSearchScopeModel model = new ElasticsearchSearchScopeModel(indexModels);
        return new ElasticsearchIndexSearchScope(this.mappingContext, this.searchBackendContext, model);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "searchBackendContext=" + this.searchBackendContext + ", indexManagers=" + this.indexManagers + "]";
    }
}

