/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexWorkExecutor
implements IndexWorkExecutor {
    private final ElasticsearchWorkBuilderFactory builderFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final URLEncodedString indexName;
    private final EventContext eventContext;

    public ElasticsearchIndexWorkExecutor(ElasticsearchWorkBuilderFactory builderFactory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, EventContext eventContext) {
        this.builderFactory = builderFactory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.eventContext = eventContext;
    }

    public CompletableFuture<?> optimize() {
        return this.orchestrator.submit(this.builderFactory.optimize().index(this.indexName).build());
    }

    public CompletableFuture<?> purge(String tenantId) {
        this.multiTenancyStrategy.checkTenantId(tenantId, this.eventContext);
        JsonObject matchAll = new JsonObject();
        matchAll.add("match_all", (JsonElement)new JsonObject());
        JsonObject document = new JsonObject();
        document.add("query", (JsonElement)this.multiTenancyStrategy.decorateJsonQuery(matchAll, tenantId));
        return this.orchestrator.submit(this.builderFactory.deleteByQuery(this.indexName, document).build());
    }

    public CompletableFuture<?> flush() {
        return this.orchestrator.submit(this.builderFactory.flush().index(this.indexName).build());
    }
}

