/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;

public class ElasticsearchExistsPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements ExistsPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor EXISTS_ACCESSOR = JsonAccessor.root().property("exists").asObject();
    private static final JsonAccessor<String> FIELD_ACCESSOR = JsonAccessor.root().property("field").asString();
    private final String absoluteFieldPath;

    ElasticsearchExistsPredicateBuilder(String absoluteFieldPath) {
        this.absoluteFieldPath = absoluteFieldPath;
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        FIELD_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        EXISTS_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }
}

