/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.query.spi.IndexSearchQuery;
import org.hibernate.search.engine.search.query.spi.IndexSearchResult;
import org.hibernate.search.util.common.impl.Futures;

public class ElasticsearchIndexSearchQuery<T>
implements IndexSearchQuery<T> {
    private static final long MAX_RESULT_WINDOW_SIZE = 10000L;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final Set<URLEncodedString> indexNames;
    private final SessionContextImplementor sessionContext;
    private final Set<String> routingKeys;
    private final JsonObject payload;
    private final ElasticsearchSearchResultExtractor<T> searchResultExtractor;

    public ElasticsearchIndexSearchQuery(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchWorkOrchestrator queryOrchestrator, Set<URLEncodedString> indexNames, SessionContextImplementor sessionContext, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchResultExtractor<T> searchResultExtractor) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.indexNames = indexNames;
        this.sessionContext = sessionContext;
        this.routingKeys = routingKeys;
        this.payload = payload;
        this.searchResultExtractor = searchResultExtractor;
    }

    public String getQueryString() {
        return this.payload.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getQueryString() + "]";
    }

    public IndexSearchResult<T> fetch(Long limit, Long offset) {
        Object work = this.workFactory.search(this.payload, this.searchResultExtractor).indexes(this.indexNames).paging(this.defaultedLimit(limit, offset), offset).routingKeys(this.routingKeys).build();
        return ((ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work))).loadBlocking(this.sessionContext);
    }

    public long fetchTotalHitCount() {
        JsonObject filteredPayload = new JsonObject();
        Optional querySubTree = JsonAccessor.root().property("query").asObject().get(this.payload);
        if (querySubTree.isPresent()) {
            filteredPayload.add("query", (JsonElement)querySubTree.get());
        }
        Object work = this.workFactory.count(this.indexNames).query(filteredPayload).routingKeys(this.routingKeys).build();
        return (Long)this.queryOrchestrator.submit(work).join();
    }

    private Long defaultedLimit(Long limit, Long offset) {
        if (limit != null) {
            return limit;
        }
        long maxLimitThatElasticsearchWillAccept = 10000L;
        if (offset != null) {
            maxLimitThatElasticsearchWillAccept -= offset.longValue();
        }
        return maxLimitThatElasticsearchWillAccept;
    }
}

