/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.builder.factory.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.Elasticsearch7WorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.CreateIndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.GetIndexTypeMappingWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.PutIndexMappingWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.SearchWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.CreateIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.GetIndexTypeMappingWork;
import org.hibernate.search.backend.elasticsearch.work.impl.PutIndexTypeMappingWork;

public class Elasticsearch6WorkBuilderFactory
extends Elasticsearch7WorkBuilderFactory {
    public Elasticsearch6WorkBuilderFactory(GsonProvider gsonProvider) {
        super(gsonProvider);
    }

    @Override
    public <T> SearchWorkBuilder<T> search(JsonObject payload, ElasticsearchSearchResultExtractor<T> searchResultExtractor) {
        return ElasticsearchSearchWork.Builder.forElasticsearch6AndBelow(payload, searchResultExtractor);
    }

    @Override
    public CreateIndexWorkBuilder createIndex(URLEncodedString indexName) {
        return CreateIndexWork.Builder.forElasticsearch6AndBelow(this.gsonProvider, indexName, Paths.DOC);
    }

    @Override
    public GetIndexTypeMappingWorkBuilder getIndexTypeMapping(URLEncodedString indexName) {
        return GetIndexTypeMappingWork.Builder.forElasticsearch6AndBelow(indexName, Paths.DOC);
    }

    @Override
    public PutIndexMappingWorkBuilder putIndexTypeMapping(URLEncodedString indexName, RootTypeMapping mapping) {
        return PutIndexTypeMappingWork.Builder.forElasticsearch6AndBelow(this.gsonProvider, indexName, Paths.DOC, mapping);
    }

    @Override
    protected URLEncodedString getTypeKeyword() {
        return Paths.DOC;
    }
}

