/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalysisComponentDefinitionContext;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchTypedAnalysisComponentDefinitionContext;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionContributor;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.AnalysisDefinition;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchAnalysisComponentDefinitionContext<D extends AnalysisDefinition>
implements ElasticsearchTypedAnalysisComponentDefinitionContext,
ElasticsearchAnalysisComponentDefinitionContext,
ElasticsearchAnalysisDefinitionContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final String name;
    protected final D definition;

    AbstractElasticsearchAnalysisComponentDefinitionContext(String name, D definition) {
        this.name = name;
        this.definition = definition;
    }

    @Override
    public ElasticsearchTypedAnalysisComponentDefinitionContext type(String name) {
        ((AnalysisDefinition)this.definition).setType(name);
        return this;
    }

    private ElasticsearchTypedAnalysisComponentDefinitionContext param(String name, JsonElement value) {
        JsonElement previous;
        Map<String, JsonElement> parameters = ((AnalysisDefinition)this.definition).getParameters();
        if (parameters == null) {
            parameters = new LinkedHashMap<String, JsonElement>();
            ((AnalysisDefinition)this.definition).setParameters(parameters);
        }
        if ((previous = parameters.putIfAbsent(name, value)) != null) {
            throw log.analysisComponentParameterConflict(name, previous, value);
        }
        return this;
    }

    @Override
    public ElasticsearchTypedAnalysisComponentDefinitionContext param(String name, String value) {
        return this.param(name, (JsonElement)new JsonPrimitive(value));
    }

    @Override
    public ElasticsearchTypedAnalysisComponentDefinitionContext param(String name, String ... values) {
        JsonArray array = new JsonArray();
        for (String value : values) {
            array.add(value);
        }
        return this.param(name, (JsonElement)array);
    }

    @Override
    public ElasticsearchTypedAnalysisComponentDefinitionContext param(String name, boolean value) {
        return this.param(name, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
    }

    @Override
    public ElasticsearchTypedAnalysisComponentDefinitionContext param(String name, boolean ... values) {
        JsonArray array = new JsonArray();
        for (boolean value : values) {
            array.add(Boolean.valueOf(value));
        }
        return this.param(name, (JsonElement)array);
    }

    @Override
    public ElasticsearchTypedAnalysisComponentDefinitionContext param(String name, Number value) {
        return this.param(name, (JsonElement)new JsonPrimitive(value));
    }

    @Override
    public ElasticsearchTypedAnalysisComponentDefinitionContext param(String name, Number ... values) {
        JsonArray array = new JsonArray();
        for (Number value : values) {
            array.add(value);
        }
        return this.param(name, (JsonElement)array);
    }
}

