/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.gson.impl.AbstractTypingJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.ObjectPropertyJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.util.common.impl.Contracts;

public class JsonObjectAccessorImpl
extends AbstractTypingJsonAccessor<JsonObject>
implements JsonObjectAccessor,
JsonCompositeAccessor<JsonObject> {
    private static final Pattern DOT_REGEX = Pattern.compile("\\.");

    public JsonObjectAccessorImpl(JsonAccessor<JsonElement> parent) {
        super(parent);
    }

    @Override
    protected JsonElementType<JsonObject> getExpectedElementType() {
        return JsonElementTypes.OBJECT;
    }

    @Override
    public JsonObject getOrCreate(JsonObject root) throws UnexpectedJsonElementTypeException {
        return this.getOrCreate(root, JsonObject::new);
    }

    @Override
    public UnknownTypeJsonAccessor property(String propertyName) {
        Contracts.assertNotNullNorEmpty((String)propertyName, (String)"propertyName");
        return new ObjectPropertyJsonAccessor(this, propertyName);
    }

    @Override
    public UnknownTypeJsonAccessor path(String dotSeparatedPath) {
        Contracts.assertNotNullNorEmpty((String)dotSeparatedPath, (String)"dotSeparatedPath");
        String[] components = DOT_REGEX.split(dotSeparatedPath);
        String leaf = components[components.length - 1];
        JsonObjectAccessor parent = this;
        for (int i = 0; i < components.length - 1; ++i) {
            parent = parent.property(components[i]).asObject();
        }
        return parent.property(leaf);
    }
}

