/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessorImpl;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.util.common.AssertionFailure;

class RootJsonAccessor
implements JsonCompositeAccessor<JsonElement> {
    static final JsonObjectAccessor INSTANCE = new JsonObjectAccessorImpl(new RootJsonAccessor());

    private RootJsonAccessor() {
    }

    @Override
    public Optional<JsonElement> get(JsonObject root) {
        return Optional.of(this.requireRoot(root));
    }

    private JsonObject requireRoot(JsonObject root) {
        if (root == null) {
            throw new AssertionFailure("A null root was encountered");
        }
        return root;
    }

    @Override
    public void set(JsonObject root, JsonElement value) {
        throw new UnsupportedOperationException("Cannot set the root element");
    }

    @Override
    public void add(JsonObject root, JsonElement value) {
        throw new UnsupportedOperationException("Cannot add a value to the root element");
    }

    @Override
    public JsonObject getOrCreate(JsonObject root, Supplier<? extends JsonElement> newValueSupplier) throws UnexpectedJsonElementTypeException {
        return this.requireRoot(root);
    }

    @Override
    public JsonObject getOrCreate(JsonObject root) throws UnexpectedJsonElementTypeException {
        return this.requireRoot(root);
    }

    public String toString() {
        return "root";
    }

    @Override
    public String getStaticAbsolutePath() {
        return null;
    }
}

