/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.multitenancy.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class NoMultiTenancyStrategy
implements MultiTenancyStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<String> HIT_ID_ACCESSOR = JsonAccessor.root().property("_id").asString();

    @Override
    public boolean isMultiTenancySupported() {
        return false;
    }

    @Override
    public void contributeToMapping(RootTypeMapping rootTypeMapping) {
    }

    @Override
    public String toElasticsearchId(String tenantId, String id) {
        return id;
    }

    @Override
    public void contributeToIndexedDocument(JsonObject document, String tenantId, String id) {
    }

    @Override
    public JsonObject decorateJsonQuery(JsonObject originalJsonQuery, String tenantId) {
        return originalJsonQuery;
    }

    @Override
    public void contributeToSearchRequest(JsonObject requestBody) {
    }

    @Override
    public String extractTenantScopedDocumentId(JsonObject hit) {
        return HIT_ID_ACCESSOR.get(hit).orElseThrow(log::elasticsearchResponseMissingData);
    }

    @Override
    public void checkTenantId(String tenantId, EventContext backendContext) {
        if (tenantId != null) {
            throw log.tenantIdProvidedButMultiTenancyDisabled(tenantId, backendContext);
        }
    }
}

