/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchAccumulatingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSharedWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractElasticsearchSharedWorkOrchestrator
implements ElasticsearchSharedWorkOrchestrator,
AutoCloseable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private boolean open = true;
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();

    protected AbstractElasticsearchSharedWorkOrchestrator(String name) {
        this.name = name;
    }

    protected final String getName() {
        return this.name;
    }

    @Override
    public CompletableFuture<?> submit(List<ElasticsearchWork<?>> works) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        this.submit(new MultipleWorkChangeset(works, future));
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(ElasticsearchWork<T> work) {
        CompletableFuture future = new CompletableFuture();
        this.submit(new SingleWorkChangeset<T>(work, future));
        return future;
    }

    @Override
    public void close() {
        this.shutdownLock.writeLock().lock();
        try {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.doClose();
        }
        finally {
            this.shutdownLock.writeLock().unlock();
        }
    }

    protected abstract void doSubmit(Changeset var1) throws InterruptedException;

    protected abstract void doClose();

    void submit(Changeset changeset) {
        if (!this.shutdownLock.readLock().tryLock()) {
            throw log.orchestratorShutDownBeforeSubmittingChangeset(this.name);
        }
        try {
            if (!this.open) {
                throw log.orchestratorShutDownBeforeSubmittingChangeset(this.name);
            }
            this.doSubmit(changeset);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.threadInterruptedWhileSubmittingChangeset(this.name);
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    static class SingleWorkChangeset<T>
    implements Changeset {
        private final ElasticsearchWork<T> work;
        private final CompletableFuture<T> future;

        SingleWorkChangeset(ElasticsearchWork<T> work, CompletableFuture<T> future) {
            this.work = work;
            this.future = future;
        }

        @Override
        public void submitTo(ElasticsearchAccumulatingWorkOrchestrator delegate) {
            delegate.submit(this.work).whenComplete(Futures.copyHandler(this.future));
        }

        @Override
        public CompletableFuture<?> getFuture() {
            return this.future;
        }
    }

    static class MultipleWorkChangeset
    implements Changeset {
        private final List<ElasticsearchWork<?>> works;
        private final CompletableFuture<Object> future;

        MultipleWorkChangeset(List<ElasticsearchWork<?>> works, CompletableFuture<Object> future) {
            this.works = new ArrayList(works);
            this.future = future;
        }

        @Override
        public void submitTo(ElasticsearchAccumulatingWorkOrchestrator delegate) {
            delegate.submit(this.works).whenComplete(Futures.copyHandler(this.future));
        }

        @Override
        public CompletableFuture<?> getFuture() {
            return this.future;
        }
    }

    static interface Changeset {
        public void submitTo(ElasticsearchAccumulatingWorkOrchestrator var1);

        public CompletableFuture<?> getFuture();
    }
}

