/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import org.hibernate.search.backend.elasticsearch.orchestration.impl.ContextualErrorHandler;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.engine.common.spi.ErrorContextBuilder;
import org.hibernate.search.engine.common.spi.ErrorHandler;

class DefaultContextualErrorHandler
implements ContextualErrorHandler {
    private final ErrorHandler errorHandler;
    private ErrorContextBuilder errorContextBuilder;
    private Throwable errorThatOccurred;

    public DefaultContextualErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void markAsFailed(ElasticsearchWork<?> work, Throwable throwable) {
        Object info = work.getInfo();
        if (info != null) {
            this.getErrorContextBuilder().operationAtFault(info);
            this.getErrorContextBuilder().addWorkThatFailed(info);
        }
        this.addThrowable(throwable);
    }

    @Override
    public void markAsSkipped(ElasticsearchWork<?> work) {
        Object info = work.getInfo();
        if (info != null) {
            this.getErrorContextBuilder().addWorkThatFailed(info);
        }
    }

    @Override
    public void addThrowable(Throwable throwable) {
        if (this.errorThatOccurred == null) {
            this.errorThatOccurred = throwable;
        } else {
            this.errorThatOccurred.addSuppressed(throwable);
        }
    }

    @Override
    public void handle() {
        if (this.errorContextBuilder != null || this.errorThatOccurred != null) {
            if (this.errorThatOccurred != null) {
                this.getErrorContextBuilder().errorThatOccurred(this.errorThatOccurred);
            }
            this.errorHandler.handle(this.getErrorContextBuilder().createErrorContext());
        }
    }

    private ErrorContextBuilder getErrorContextBuilder() {
        if (this.errorContextBuilder == null) {
            this.errorContextBuilder = new ErrorContextBuilder();
        }
        return this.errorContextBuilder;
    }
}

