/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchAccumulatingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkAggregator;

class ElasticsearchSerialChangesetsWorkOrchestrator
implements ElasticsearchAccumulatingWorkOrchestrator {
    private final BulkAndSequenceAggregator aggregator;
    private CompletableFuture<Void> future = CompletableFuture.completedFuture(null);

    public ElasticsearchSerialChangesetsWorkOrchestrator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
        this.aggregator = new BulkAndSequenceAggregator(sequenceBuilder, bulker);
    }

    public CompletableFuture<Void> submit(List<ElasticsearchWork<?>> nonBulkedWorks) {
        this.aggregator.init(this.future);
        for (ElasticsearchWork<?> work : nonBulkedWorks) {
            work.aggregate(this.aggregator);
        }
        CompletableFuture<Void> sequenceFuture = this.aggregator.buildSequence();
        this.future = sequenceFuture;
        return sequenceFuture;
    }

    @Override
    public <T> CompletableFuture<T> submit(ElasticsearchWork<T> work) {
        this.aggregator.init(this.future);
        CompletableFuture<T> workFuture = work.aggregate(this.aggregator);
        this.future = this.aggregator.buildSequence();
        return workFuture;
    }

    public CompletableFuture<Void> executeSubmitted() {
        this.aggregator.finalizeBulkWork();
        return this.future;
    }

    @Override
    public void reset() {
        this.aggregator.reset();
    }

    private static class BulkAndSequenceAggregator
    implements ElasticsearchWorkAggregator {
        private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
        private final ElasticsearchWorkBulker bulker;

        public BulkAndSequenceAggregator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
            this.sequenceBuilder = sequenceBuilder;
            this.bulker = bulker;
        }

        public void init(CompletableFuture<?> previous) {
            this.sequenceBuilder.init(previous);
        }

        @Override
        public <T> CompletableFuture<T> addBulkable(BulkableElasticsearchWork<T> work) {
            return this.bulker.add(work);
        }

        @Override
        public <T> CompletableFuture<T> addNonBulkable(ElasticsearchWork<T> work) {
            if (this.bulker.addWorksToSequence()) {
                this.bulker.finalizeBulkWork();
            }
            return this.sequenceBuilder.addNonBulkExecution(work);
        }

        public CompletableFuture<Void> buildSequence() {
            this.bulker.addWorksToSequence();
            return this.sequenceBuilder.build();
        }

        public void finalizeBulkWork() {
            this.bulker.finalizeBulkWork();
        }

        public void reset() {
            this.bulker.reset();
        }
    }
}

