/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.DefaultContextualErrorHandler;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchAccumulatingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchBatchingSharedWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchDefaultWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchDefaultWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchDefaultWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchIgnoreRefreshWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelChangesetsWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchRefreshableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialChangesetsWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSharedWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchWorkOrchestratorProvider
implements AutoCloseable {
    private static final int SERIAL_MIN_BULK_SIZE = 2;
    private static final int PARALLEL_MIN_BULK_SIZE = 1;
    private static final int MAX_BULK_SIZE = 250;
    private static final int SERIAL_MAX_CHANGESETS_PER_BATCH = 2500;
    private static final int PARALLEL_MAX_CHANGESETS_PER_BATCH = 5000;
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchLink link;
    private final ErrorHandler errorHandler;
    private final ElasticsearchBatchingSharedWorkOrchestrator rootParallelOrchestrator;

    public ElasticsearchWorkOrchestratorProvider(String rootParallelOrchestratorName, ElasticsearchLink link, ErrorHandler errorHandler) {
        this.link = link;
        this.errorHandler = errorHandler;
        this.rootParallelOrchestrator = this.createBatchingSharedOrchestrator(rootParallelOrchestratorName, 5000, false, this.createThreadUnsafeParallelOrchestrator(this::createIgnoreDirtyWorkExecutionContext, false));
    }

    @Override
    public void close() {
        try {
            this.rootParallelOrchestrator.awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedWhileWaitingForRequestCompletion(e);
        }
        finally {
            this.rootParallelOrchestrator.close();
        }
    }

    public void start() {
        this.rootParallelOrchestrator.start();
    }

    public ElasticsearchBatchingSharedWorkOrchestrator getRootParallelOrchestrator() {
        return this.rootParallelOrchestrator;
    }

    public ElasticsearchSharedWorkOrchestrator createSerialOrchestrator(String name, boolean refreshAfterWrite) {
        boolean refreshInBulkApiCall;
        Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier;
        if (refreshAfterWrite) {
            contextSupplier = this::createRefreshingWorkExecutionContext;
            refreshInBulkApiCall = true;
        } else {
            contextSupplier = this::createIgnoreDirtyWorkExecutionContext;
            refreshInBulkApiCall = false;
        }
        ElasticsearchAccumulatingWorkOrchestrator delegate = this.createThreadUnsafeSerialOrchestrator(contextSupplier, refreshInBulkApiCall);
        return this.createBatchingSharedOrchestrator(name, 2500, true, delegate);
    }

    public ElasticsearchSharedWorkOrchestrator createParallelOrchestrator(String name) {
        return this.rootParallelOrchestrator.createChild(name);
    }

    private ElasticsearchBatchingSharedWorkOrchestrator createBatchingSharedOrchestrator(String name, int maxChangesetsPerBatch, boolean fair, ElasticsearchAccumulatingWorkOrchestrator delegate) {
        return new ElasticsearchBatchingSharedWorkOrchestrator(name, maxChangesetsPerBatch, fair, delegate, this.errorHandler);
    }

    private ElasticsearchAccumulatingWorkOrchestrator createThreadUnsafeSerialOrchestrator(Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier, boolean refreshInBulkAPICall) {
        ElasticsearchWorkSequenceBuilder sequenceBuilder = this.createSequenceBuilder(contextSupplier);
        ElasticsearchWorkBulker bulker = this.createBulker(sequenceBuilder, 2, refreshInBulkAPICall);
        return new ElasticsearchSerialChangesetsWorkOrchestrator(sequenceBuilder, bulker);
    }

    private ElasticsearchAccumulatingWorkOrchestrator createThreadUnsafeParallelOrchestrator(Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier, boolean refreshInBulkAPICall) {
        ElasticsearchWorkSequenceBuilder sequenceBuilder = this.createSequenceBuilder(contextSupplier);
        ElasticsearchWorkBulker bulker = this.createBulker(sequenceBuilder, 1, refreshInBulkAPICall);
        return new ElasticsearchParallelChangesetsWorkOrchestrator(sequenceBuilder, bulker);
    }

    private ElasticsearchWorkSequenceBuilder createSequenceBuilder(Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier) {
        return new ElasticsearchDefaultWorkSequenceBuilder(contextSupplier, () -> new DefaultContextualErrorHandler(this.errorHandler));
    }

    private ElasticsearchWorkBulker createBulker(ElasticsearchWorkSequenceBuilder sequenceBuilder, int minBulkSize, boolean refreshInBulkAPICall) {
        return new ElasticsearchDefaultWorkBulker(sequenceBuilder, worksToBulk -> this.link.getWorkBuilderFactory().bulk((List<? extends BulkableElasticsearchWork<?>>)worksToBulk).refresh(refreshInBulkAPICall).build(), minBulkSize, 250);
    }

    private ElasticsearchRefreshableWorkExecutionContext createIgnoreDirtyWorkExecutionContext() {
        return new ElasticsearchIgnoreRefreshWorkExecutionContext(this.link.getClient(), this.link.getGsonProvider());
    }

    private ElasticsearchRefreshableWorkExecutionContext createRefreshingWorkExecutionContext() {
        return new ElasticsearchDefaultWorkExecutionContext(this.link.getClient(), this.link.getGsonProvider(), this.link.getWorkBuilderFactory(), this.errorHandler);
    }
}

