/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import com.google.gson.Gson;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;

public final class ElasticsearchSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;

    public ElasticsearchSearchContext(MappingContextImplementor mappingContext, Gson userFacingGson, MultiTenancyStrategy multiTenancyStrategy) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.userFacingGson = userFacingGson;
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    public ToDocumentIdentifierValueConvertContext getToDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext getToDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public Gson getUserFacingGson() {
        return this.userFacingGson;
    }

    public String toElasticsearchId(String tenantId, String id) {
        return this.multiTenancyStrategy.toElasticsearchId(tenantId, id);
    }
}

